/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.DateTimeColumFilterValue;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.ui.jfx.util.binding.ValidProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;
import org.joda.time.LocalDateTime;

public class DateTimeFilterValueField
extends FilterValueField<DateTimeColumFilterValue> {
    private final ObjectProperty<LocalDateTime> value;
    private final TextField textField;
    private final ValidProperty valid;
    private final LocalService localService;

    public DateTimeFilterValueField(LocalService localService) {
        this.localService = localService;
        this.textField = new TextField();
        this.value = new SimpleObjectProperty<LocalDateTime>();
        this.valid = new ValidProperty(this.textField);
        this.valid.bind(this.value.isNotNull());
        this.textField.setText(this.localService.getJodaDateFormat().printSimpleDateFormat(LocalDateTime.now().withTime(0, 0, 0, 0)));
        this.textField.textProperty().addListener(this::textChanged);
        this.textField.setAlignment(Pos.CENTER_LEFT);
        this.setCenter(this.textField);
        this.textField.setPromptText(localService.getJodaDateFormat().getSimpleDateFormatPattern());
    }

    private void textChanged(ObservableValue<? extends String> paramObservableValue, String oldValue, String newValue) {
        if (newValue != null && !newValue.isEmpty()) {
            this.value.setValue(this.localService.getJodaDateFormat().parseSimpleDateFormat(newValue));
        } else {
            this.value.setValue(null);
        }
    }

    @Override
    public ReadOnlyBooleanProperty validProperty() {
        return this.valid;
    }

    @Override
    public boolean isValid() {
        return this.valid.get();
    }

    @Override
    public DateTimeColumFilterValue getValue() {
        return new DateTimeColumFilterValue((LocalDateTime)this.value.getValue(), null);
    }

    @Override
    public void setValue(DateTimeColumFilterValue dateTimeColumFilterValue) {
        this.textField.setText(this.localService.getJodaDateFormat().printSimpleDateFormat(dateTimeColumFilterValue.getLocalDateTime()));
    }
}

