/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.control.notification;

import com.deutscheboerse.comxerv.comtrader.jfx.components.icon.IconView;
import com.deutscheboerse.comxerv.comtrader.jfx.service.NotificationService;
import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.ui.jfx.util.control.PopupControlSkin;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.event.Event;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.PopupControl;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifierPopup
extends PopupControl
implements NotificationService.Notifier {
    private static final Logger LOG = LoggerFactory.getLogger(NotifierPopup.class);
    protected static final double PADDING_FROM_EDGE = 50.0;
    private static final int VISIBLE_TIME_IN_MILLIS = 5000;
    private static final int FADE_OUT_DURATION_IN_MILLIS = 500;
    private static final double MIN_WIDTH = 300.0;
    private final Region owner;
    private final Pos alignment;
    private final Label content;
    private final IconView graphic;
    private final Timeline timeline;

    public NotifierPopup(Region owner, Pos alignment) {
        this.owner = owner;
        this.alignment = alignment;
        this.content = new Label();
        this.graphic = new IconView();
        this.content.setGraphic(this.graphic);
        this.content.setWrapText(true);
        this.content.getStyleClass().add("notification");
        this.content.setOnMouseClicked(event -> this.fadeOut());
        this.setAutoHide(true);
        this.setConsumeAutoHidingEvents(false);
        this.setOnAutoHide(event -> this.checkParentVisible(owner, event));
        this.setSkin(new PopupControlSkin(this, this.content));
        this.setOpacity(0.0);
        KeyValue fadeOutBegin = new KeyValue(this.opacityProperty(), 1.0);
        KeyValue fadeOutEnd = new KeyValue(this.opacityProperty(), 0.0);
        KeyFrame kfBegin = new KeyFrame(Duration.ZERO, fadeOutBegin);
        KeyFrame kfEnd = new KeyFrame(Duration.millis(500.0), fadeOutEnd);
        this.timeline = new Timeline(kfBegin, kfEnd);
        this.timeline.setDelay(Duration.millis(5000.0));
        this.timeline.setOnFinished(actionEvent -> this.hide());
    }

    private void checkParentVisible(Parent parent, Event autoHideEvent) {
        if (parent.isVisible()) {
            if (parent.getParent() != null) {
                this.checkParentVisible(parent.getParent(), autoHideEvent);
            } else {
                autoHideEvent.consume();
            }
        } else {
            this.hide();
        }
    }

    @Override
    public void showNotification(String message, NotificationService.NotificationSeverity severity) {
        LOG.info("Showing {} notification: {}", (Object)severity, (Object)message);
        this.content.setText(message);
        if (severity != null) {
            this.graphic.setIconStyleClass(this.getIconStyleClass(severity));
            this.content.setContentDisplay(ContentDisplay.LEFT);
        } else {
            this.content.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
        this.content.layout();
        this.content.getWidth();
        this.content.prefWidth(20.0);
        this.show(this.owner, 0.0, 0.0);
        this.setOpacity(1.0);
        this.size();
        this.align();
        this.fadeOut();
    }

    @Override
    public void showNotification(AsyncResponse response) {
        switch (response.getStatus()) {
            case ERROR: {
                this.showNotification(response.getMessage(), NotificationService.NotificationSeverity.ERROR);
                break;
            }
            case SUCCESS: {
                this.showNotification(response.getMessage(), NotificationService.NotificationSeverity.SUCCESS);
                break;
            }
            default: {
                this.showNotification(response.getMessage(), NotificationService.NotificationSeverity.INFO);
            }
        }
    }

    private String getIconStyleClass(NotificationService.NotificationSeverity severity) {
        switch (severity) {
            case SUCCESS: {
                return "icon-success-32";
            }
            case WARNING: {
                return "icon-sign-warning-32";
            }
            case INFO: {
                return "icon-info-32";
            }
            case ERROR: {
                return "icon-error-32";
            }
        }
        return null;
    }

    private void size() {
        for (double width = 300.0; width < this.owner.getWidth(); width += 1.0) {
            double height = this.content.prefHeight(width);
            if (!(width / height > 1.61803398875)) continue;
            this.setWidth(width);
            this.setHeight(height);
            this.content.setPrefWidth(width);
            this.content.setPrefHeight(height);
            this.content.layout();
            return;
        }
    }

    private void align() {
        double width = this.getWidth();
        double height = this.getHeight();
        Bounds ownerScreenBounds = this.owner.localToScreen(this.owner.getBoundsInLocal());
        if (this.alignment.getVpos() == VPos.TOP) {
            this.setY(ownerScreenBounds.getMinY() + 50.0);
        } else if (this.alignment.getVpos() == VPos.BOTTOM) {
            this.setY(ownerScreenBounds.getMaxY() - 50.0);
        } else {
            this.setY(ownerScreenBounds.getMinY() + (ownerScreenBounds.getHeight() - height) / 2.0);
        }
        if (this.alignment.getHpos() == HPos.LEFT) {
            this.setX(ownerScreenBounds.getMinX() + 50.0);
        } else if (this.alignment.getHpos() == HPos.RIGHT) {
            this.setX(ownerScreenBounds.getMaxX() - 50.0);
        } else {
            this.setX(ownerScreenBounds.getMinX() + (ownerScreenBounds.getWidth() - width) / 2.0);
        }
        this.setWidth(width);
        this.setHeight(height);
    }

    private void fadeOut() {
        this.timeline.play();
    }
}

