/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.customization.common;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableView;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Region;

public class AutoScrollTableView<S>
extends TableView<S> {
    private static final double HOTAREA_HEIGHT = 20.0;
    private Scroller scroller = new Scroller();
    private ScheduledFuture scheduledFuture;
    private ScheduledExecutorService executorService;

    public AutoScrollTableView(ApplicationContext applicationContext) {
        this.executorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DROPPED, this::stopAutoScrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_DONE, this::stopAutoScrollIfNeeded);
    }

    protected void smoothScrollTo(int index) {
        VirtualFlow<?> flow = this.getVirtualFlow();
        if (flow != null) {
            if (this.scheduledFuture == null) {
                this.scheduledFuture = this.executorService.scheduleAtFixedRate(this.scroller::scroll, 300L, 15L, TimeUnit.MILLISECONDS);
            }
            this.scroller.setBreakCondition(() -> index > ((IndexedCell)flow.getFirstVisibleCell()).getIndex() && index < ((IndexedCell)flow.getLastVisibleCell()).getIndex());
            if (index < ((IndexedCell)flow.getFirstVisibleCell()).getIndex()) {
                this.scroller.setDelta(-20.0);
            } else if (index > ((IndexedCell)flow.getLastVisibleCell()).getIndex()) {
                this.scroller.setDelta(20.0);
            }
        }
    }

    protected void autoscroll(double yOffset) {
        if (this.scheduledFuture == null) {
            this.scheduledFuture = this.executorService.scheduleAtFixedRate(this.scroller::scroll, 300L, 15L, TimeUnit.MILLISECONDS);
        }
        this.scroller.setBreakCondition(() -> false);
        this.scroller.setDelta(yOffset);
    }

    private void stopAutoScrollIfNeeded(DragEvent evt) {
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        evt.acceptTransferModes(TransferMode.ANY);
        Region hotRegion = this.getClippedContainer();
        if (hotRegion != null && hotRegion.getBoundsInLocal().getWidth() < 1.0 && (hotRegion = this).getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded(evt);
            return;
        }
        double yOffset = 0.0;
        if (hotRegion != null) {
            double delta = evt.getSceneY() - hotRegion.localToScene(0.0, 0.0).getY();
            if (delta < 20.0) {
                yOffset = -(20.0 - delta);
            }
            if ((delta = hotRegion.localToScene(0.0, 0.0).getY() + hotRegion.getHeight() - evt.getSceneY()) < 20.0) {
                yOffset = 20.0 - delta;
            }
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded(evt);
        }
    }

    private VirtualFlow<?> getVirtualFlow() {
        return (VirtualFlow)this.lookup("VirtualFlow");
    }

    private Region getClippedContainer() {
        for (Node child : this.getVirtualFlow().getChildrenUnmodifiable()) {
            if (!child.getStyleClass().contains("clipped-container")) continue;
            return (Region)child;
        }
        return null;
    }

    public class Scroller {
        private double yOffset;
        private Supplier<Boolean> breakCondition;

        public void scroll() {
            Platform.runLater(() -> {
                VirtualFlow<?> flow = AutoScrollTableView.this.getVirtualFlow();
                double adjustedPixels = flow.scrollPixels(this.yOffset);
                if (adjustedPixels == 0.0 || this.breakCondition.get().booleanValue()) {
                    AutoScrollTableView.this.stopAutoScrollIfNeeded(null);
                }
            });
        }

        public void setDelta(double yOffset) {
            this.yOffset = yOffset;
        }

        public void setBreakCondition(Supplier<Boolean> breakCondition) {
            this.breakCondition = breakCondition;
        }
    }
}

