/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.filter.column;

import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterDomain;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.FilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.filter.StringDisplayFilterValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.ColumnFilter;
import com.deutscheboerse.comxerv.comtrader.jfx.components.filter.PredicateType;
import com.google.common.collect.Lists;
import java.util.List;

public class StringColumnFilter
implements ColumnFilter<String, String> {
    private FilterDomain<String> filterDomain;

    @Override
    public List<PredicateType> getPredicateTypes() {
        return Lists.newArrayList(PredicateType.EQUAL, PredicateType.NOT_EQUAL, PredicateType.SUBSTRING, PredicateType.NOT_SUBSTRING, PredicateType.IS_EMPTY, PredicateType.IS_NOT_EMPTY);
    }

    @Override
    public FilterValueField<String> getValueField(PredicateType predicateType) {
        return predicateType == PredicateType.IS_EMPTY || predicateType == PredicateType.IS_NOT_EMPTY ? null : new StringDisplayFilterValueField(this.filterDomain);
    }

    @Override
    public boolean matches(PredicateType predicateType, String cellValue, String filterValue) {
        switch (predicateType) {
            case EQUAL: {
                return (cellValue == null || cellValue.isEmpty()) && (filterValue == null || filterValue.isEmpty()) || cellValue != null && cellValue.equalsIgnoreCase(filterValue);
            }
            case NOT_EQUAL: {
                return !this.matches(PredicateType.EQUAL, cellValue, filterValue);
            }
            case SUBSTRING: {
                return filterValue == null || filterValue.isEmpty() || cellValue != null && cellValue.toLowerCase().contains(filterValue.toLowerCase());
            }
            case NOT_SUBSTRING: {
                return !this.matches(PredicateType.SUBSTRING, cellValue, filterValue);
            }
            case IS_EMPTY: {
                return cellValue == null || cellValue.isEmpty();
            }
            case IS_NOT_EMPTY: {
                return cellValue != null && !cellValue.isEmpty() && !cellValue.trim().isEmpty();
            }
        }
        throw new IllegalArgumentException("Wrong predicate type");
    }

    public FilterDomain<String> getFilterDomain() {
        return this.filterDomain;
    }

    public void setFilterDomain(FilterDomain<String> filterDomain) {
        this.filterDomain = filterDomain;
    }
}

