/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel;

import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.GlobalKeyboardShortcuts;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;

@Singleton
public class GlobalKeyboardShortcutsImpl
implements GlobalKeyboardShortcuts {
    private final List<KeyboardShortcut> shortcuts = new ArrayList<KeyboardShortcut>();

    @Override
    public GlobalKeyboardShortcuts.KeyboardShortcutHandle registerKeyboardShortcut(Runnable action, KeyCodeCombination keyCodeCombination) {
        return this.registerConditionalKeyboardShortcut(action, keyCodeCombination, event -> true);
    }

    @Override
    public GlobalKeyboardShortcuts.KeyboardShortcutHandle registerConditionalKeyboardShortcut(Runnable action, KeyCodeCombination keyCodeCombination, Predicate<KeyEvent> isApplicable) {
        KeyboardShortcut keyboardShortcut = new KeyboardShortcut(action, keyCodeCombination, isApplicable);
        this.shortcuts.add(keyboardShortcut);
        return new KeyboardShortcutHandleImpl(() -> this.shortcuts.remove(keyboardShortcut), keyCodeCombination);
    }

    @Override
    public GlobalKeyboardShortcuts.KeyboardShortcutHandle registerKeyboardShortcutWhenFocused(Runnable action, KeyCodeCombination keyCodeCombination, Node container) {
        Predicate<KeyEvent> isApplicable = event -> Optional.ofNullable(container.getScene()).map(Scene::getWindow).map(Window::isFocused).orElse(false);
        return this.registerConditionalKeyboardShortcut(action, keyCodeCombination, isApplicable);
    }

    @Override
    public void handle(KeyEvent event) {
        this.shortcuts.stream().filter(keyboardShortcut -> keyboardShortcut.keyCodeCombinationMatches(event)).filter(keyboardShortcut -> keyboardShortcut.isApplicable(event)).findFirst().ifPresent(keyboardShortcut -> {
            keyboardShortcut.action.run();
            event.consume();
        });
    }

    private static final class KeyboardShortcut {
        private final Runnable action;
        private final KeyCodeCombination keyCodeCombination;
        private final Predicate<KeyEvent> isApplicable;

        public KeyboardShortcut(Runnable action, KeyCodeCombination keyCodeCombination, Predicate<KeyEvent> isApplicable) {
            this.action = action;
            this.keyCodeCombination = keyCodeCombination;
            this.isApplicable = isApplicable;
        }

        public boolean keyCodeCombinationMatches(KeyEvent event) {
            return this.keyCodeCombination.match(event);
        }

        public boolean isApplicable(KeyEvent keyEvent) {
            return this.isApplicable.test(keyEvent);
        }
    }

    private static class KeyboardShortcutHandleImpl
    implements GlobalKeyboardShortcuts.KeyboardShortcutHandle {
        private final Runnable unregisterAction;
        private final KeyCodeCombination keyCodeCombination;

        public KeyboardShortcutHandleImpl(Runnable unregisterAction, KeyCodeCombination keyCodeCombination) {
            this.unregisterAction = unregisterAction;
            this.keyCodeCombination = keyCodeCombination;
        }

        @Override
        public void unregister() {
            this.unregisterAction.run();
        }

        @Override
        public KeyCodeCombination getKeyCodeCombination() {
            return this.keyCodeCombination;
        }
    }
}

