/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.entities.type.ExecutionRestriction;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.entities.type.ValidityRestriction;
import com.deutscheboerse.comxerv.comtrader.jfx.components.Destroyable;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DefaultButton;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.OpenCloseIndicatorChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry.VwapComponent;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OnBehalfChangeEvent;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrdersToSend;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.RequestType;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Window;

@OverrideGuiConfiguration(field="#this", overrideId="LiftOrderEntryPanel", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class LiftOrderEntryPanel
extends FXMLBorderPane
implements Destroyable {
    private final LongDisplayValue initialPrice;
    private final LongDisplayValue initialQuantity;
    private final Orderbook orderbook;
    private final Direction orderDirection;
    private final OrderValidationService orderValidationService;
    private final OrderSender orderSender;
    private final BooleanProperty formValid;
    private final Order order;
    private final OverrideGuiConfigurationsExecutor overrideGuiConfigurationsExecutor;
    private ObservableValue<OrderValidationService.ValidationResult> validationResult;
    @FXML
    private Text instrumentName;
    @FXML
    private SimpleLongDisplayValueField priceField;
    @FXML
    private SimpleLongDisplayValueField quantityField;
    @FXML
    private DisplayNameArrowKeyBlockingChoiceBox<ExecutionRestriction> exeRestrictionChoiceBox;
    @FXML
    private OpenCloseIndicatorChoiceBox openCloseIndicatorField;
    @FXML
    private VwapComponent vwapComponent;
    @FXML
    private DefaultButton submitButton;
    @FXML
    private Button showErrorsButton;
    @FXML
    private Label openCloseIndicatorLabel;
    @FXML
    private VBox clearingAccountArea;

    public LiftOrderEntryPanel(ApplicationContext appContext, Order order) {
        super(appContext);
        this.initialPrice = order.getLimitPrice();
        this.initialQuantity = order.getRemainingQuantity();
        this.orderValidationService = appContext.getService(OrderValidationService.class);
        this.orderSender = appContext.getService(OrderSender.class);
        this.formValid = new SimpleBooleanProperty(false);
        this.order = new Order(order);
        this.orderDirection = this.order.getDirection();
        this.overrideGuiConfigurationsExecutor = appContext.getService(OverrideGuiConfigurationsExecutor.class);
        this.order.setAccount(appContext.getService(OrderPreferencesService.class).getDefaultAccount());
        this.order.setOrderType(OrderType.LIFT);
        this.order.setPeakQuantity(null);
        this.order.setPeakPriceDelta(null);
        this.order.setOpenOrClose(null);
        this.order.setValidityRestriction(ValidityRestriction.NONE);
        this.order.setValidityDate(null);
        this.order.setText("");
        Optional<Orderbook> orderbook = appContext.getService(OrderbookQueries.class).findByOrder(order);
        if (!orderbook.isPresent()) {
            throw new IllegalArgumentException("Invalid order - no orderbook");
        }
        this.orderbook = orderbook.get();
        appContext.getService(EventBus.class).register(this);
        this.loadFxml();
    }

    public void initialize() {
        StyleUtil.addStyleClass(this, "buy", "sell", this.orderDirection == Direction.BUY);
        this.instrumentName.setText(this.orderbook.getDeliveryArea().getDisplayName() + " " + this.orderbook.getContract().getName());
        SimpleObjectProperty<Order> orderSimpleObjectProperty = new SimpleObjectProperty<Order>(this.order);
        this.formValid.bind(this.orderValidationService.isOrderSubmittableProperty(orderSimpleObjectProperty));
        this.validationResult = this.orderValidationService.validationResultProperty(orderSimpleObjectProperty);
        if (this.validationResult != null) {
            this.validationResult.addListener((observable2, oldValue, newValue) -> {
                if (newValue.getResult() == CommonOrderValidationService.ValidationFlag.SUBMIT) {
                    this.showErrorsButton.setTooltip(null);
                    this.showErrorsButton.setText("");
                    this.showErrorsButton.setDisable(true);
                } else {
                    this.showErrorsButton.setTooltip(new Tooltip(this.orderValidationService.getValidationErrorsString(this.validationResult.getValue())));
                    this.showErrorsButton.setText("!");
                    this.showErrorsButton.setDisable(false);
                }
            });
        }
        this.quantityField.setValue(this.initialQuantity);
        this.quantityField.setMaximum(this.orderbook.getContract().getProduct().getQuantityMaxValue());
        this.quantityField.setDelta((int)this.orderbook.getContract().getProduct().getQuantityLotSize().getValue());
        this.quantityField.setMinimum(this.orderbook.getContract().getProduct().getQuantityLotSize());
        this.quantityField.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.quantityField.getValue() == null && !oldValue.booleanValue() && newValue.booleanValue()) {
                this.quantityField.setValue(this.initialQuantity);
                this.quantityField.setDelta((int)this.orderbook.getContract().getProduct().getQuantityLotSize().getValue());
            }
        });
        this.priceField.setValue(this.initialPrice);
        this.priceField.setMaximum(this.orderbook.getContract().getProduct().getPriceMaxValue());
        this.priceField.setMinimum(this.orderbook.getContract().getProduct().getPriceMinValue());
        this.priceField.textFieldFocusedProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.order.getContract() != null && !oldValue.booleanValue() && newValue.booleanValue()) {
                Product product = this.order.getContract().getProduct();
                LongDisplayValue oldPrice = this.priceField.getValue();
                long initialPrice = this.initialPrice == null ? 0L : this.initialPrice.getValue();
                this.priceField.setValue(new LongDisplayValue(oldPrice != null ? oldPrice.getValue() : initialPrice, product.getPriceDecimalShift()));
            }
        });
        this.exeRestrictionChoiceBox.setListedItems(Lists.newArrayList(ExecutionRestriction.IMMEDIATE_OR_CANCEL, ExecutionRestriction.FILL_OR_KILL));
        this.exeRestrictionChoiceBox.setValue(ExecutionRestriction.IMMEDIATE_OR_CANCEL);
        boolean supportsOpenCloseIndicator = this.orderbook.getContract().supportsOpenCloseIndicator();
        this.openCloseIndicatorLabel.setDisable(!supportsOpenCloseIndicator);
        this.openCloseIndicatorField.setDisable(!supportsOpenCloseIndicator);
        this.openCloseIndicatorField.setFutureProduct(supportsOpenCloseIndicator);
        this.vwapComponent.initializeValue(this.order, this.orderbook);
        this.order.limitPriceProperty().bind(this.priceField.valueProperty());
        this.order.remainingQuantityProperty().bind(this.quantityField.valueProperty());
        this.order.executionRestrictionProperty().bind(this.exeRestrictionChoiceBox.valueProperty());
        if (supportsOpenCloseIndicator) {
            this.order.openOrCloseProperty().bind(this.openCloseIndicatorField.valueProperty());
        }
        this.submitButton.registerDefaultAction(this.priceField, this.quantityField, this.exeRestrictionChoiceBox);
        this.submitButton.disableProperty().bind(this.formValid.not());
        this.overrideGuiConfigurationsExecutor.registerAndApply(this);
    }

    @FXML
    public void submitOrder() {
        this.orderSender.sendOrder(new OrdersToSend(this.order, RequestType.ADD));
        this.close();
    }

    @FXML
    public void close() {
        Optional.ofNullable(this.getScene()).map(Scene::getWindow).ifPresent(Window::hide);
    }

    @Override
    public void destroy() {
        this.getAppContext().getService(EventBus.class).unregister(this);
        this.destroyChildrenRecursively(this);
    }

    @Subscribe
    public void handleOnBehalfChangeEvent(OnBehalfChangeEvent event) {
        this.close();
    }

    @Subscribe
    public void handleLogoutEvent(LogoutEvent event) {
        this.close();
    }

    @FXML
    public void showErrors() {
        this.getAppContext().getService(UserAlertService.class).showConfirmationDialog(Util.getLabel("orderEntryPanel_validation_errors"), this.orderValidationService.getValidationErrorsString(this.validationResult.getValue()), new UserAlertService.Flag[0]);
    }
}

