/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.StyleUtil;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;

public class ShowErrorsButton
extends Button {
    private UserAlertService userAlertService;
    private OrderValidationService validationService;
    private ObservableValue<OrderValidationService.ValidationResult> validationResult;

    public ShowErrorsButton() {
        StyleUtil.addStyleClasses(this, "orderEntryPanelButton", "validationErrorsButton");
        this.setOnAction(this::showErrors);
    }

    public void init(UserAlertService userAlertService, OrderValidationService orderValidationService, ObservableValue<OrderValidationService.ValidationResult> validationResult) {
        this.userAlertService = userAlertService;
        this.validationService = orderValidationService;
        this.validationResult = validationResult;
        this.setTooltip(new Tooltip());
        validationResult.addListener((observable2, oldValue, newValue) -> {
            if (newValue.getResult() == CommonOrderValidationService.ValidationFlag.SUBMIT) {
                this.getTooltip().setText("");
                this.setText("");
                this.setDisable(true);
            } else {
                this.getTooltip().setText(orderValidationService.getValidationErrorsString((OrderValidationService.ValidationResult)validationResult.getValue()));
                this.setText("!");
                this.setDisable(false);
            }
        });
    }

    public void showErrors(ActionEvent event) {
        this.userAlertService.showConfirmationDialog(Util.getLabel("orderEntryPanel_validation_errors"), this.validationService.getValidationErrorsString(this.validationResult.getValue()), new UserAlertService.Flag[0]);
    }
}

