/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.orderentry;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.VWapBinding;
import com.deutscheboerse.comxerv.comtrader.entities.property.binding.LongDisplayValueStringBinding;
import com.deutscheboerse.comxerv.comtrader.entities.type.Direction;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.service.BlockOrderbookFactory;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.binding.DependentObservableValue;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;

public class VwapComponent
extends HBox {
    private static final String VWAP_NOT_AVAILABLE = Util.getLabel("commons_NotAvailableShort");
    private final BlockOrderbookFactory blockOrderbookFactory;
    private final OrderbookQueries orderbookQueries;
    @FXML
    private Text vwap;
    @FXML
    private Label vwapLabel;
    private final ObjectProperty<LongDisplayValue> value;

    public VwapComponent() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public VwapComponent(ApplicationContext appContext) {
        this.orderbookQueries = appContext.getService(OrderbookQueries.class);
        this.blockOrderbookFactory = appContext.getService(BlockOrderbookFactory.class);
        this.value = new SimpleObjectProperty<Object>(null);
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        this.vwap.textProperty().bind(new LongDisplayValueStringBinding(this.value, true, VWAP_NOT_AVAILABLE));
    }

    public void initializeValue(final Order order, final Orderbook fastOrderOrderbook) {
        this.value.bind((ObservableValue<LongDisplayValue>)new DependentObservableValue<Direction, LongDisplayValue>(this, order.directionProperty(), new Observable[0]){

            @Override
            public ObservableValue<LongDisplayValue> getObservableValue(Direction direction) {
                return new VWapBinding(fastOrderOrderbook, direction, order.limitPriceProperty(), order.remainingQuantityProperty(), order.executionRestrictionProperty());
            }
        });
    }

    public void initializeValue(ObservableValue<Order> order) {
        DependentObservableValue direction = DependentObservableValue.get(order, Order::directionProperty, new Observable[0]);
        DependentObservableValue deliveryArea = DependentObservableValue.get(order, Order::deliveryAreaProperty, new Observable[0]);
        DependentObservableValue contract = DependentObservableValue.get(order, Order::contractProperty, new Observable[0]);
        DependentObservableValue price = DependentObservableValue.get(order, Order::limitPriceProperty, new Observable[0]);
        DependentObservableValue quantity = DependentObservableValue.get(order, Order::remainingQuantityProperty, new Observable[0]);
        DependentObservableValue executionRestriction = DependentObservableValue.get(order, Order::executionRestrictionProperty, new Observable[0]);
        InvalidationListener rebindValue = observable2 -> {
            this.value.unbind();
            this.value.set(null);
            DeliveryArea deliveryAreaValue = (DeliveryArea)deliveryArea.getValue();
            Contract contractValue = (Contract)contract.getValue();
            if (contractValue != null && deliveryAreaValue != null && direction.getValue() != null) {
                Long contractId = (Long)contractValue.getId();
                String deliveryAreaId = (String)deliveryAreaValue.getId();
                if (contractValue.getType().isBlock()) {
                    Orderbook temporaryBlockOrderbook = this.blockOrderbookFactory.createTemporaryBlockOrderbook((BlockContract)contractValue, deliveryAreaValue);
                    this.value.bind(new VWapBinding(temporaryBlockOrderbook, (Direction)direction.getValue(), price, quantity, executionRestriction));
                } else {
                    this.orderbookQueries.findByContractIdAndDeliveryAreaId(contractId, deliveryAreaId).ifPresent(orderbook -> this.value.bind(new VWapBinding((Orderbook)orderbook, (Direction)direction.getValue(), price, quantity, executionRestriction)));
                }
            }
        };
        direction.addListener(rebindValue);
        contract.addListener(rebindValue);
        deliveryArea.addListener(rebindValue);
        rebindValue.invalidated(order);
    }

    public Label getVwapLabel() {
        return this.vwapLabel;
    }
}

