/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.settings;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.LongDisplayValue;
import com.deutscheboerse.comxerv.comtrader.entities.type.JodaDateFormatType;
import com.deutscheboerse.comxerv.comtrader.entities.type.NumberStyleType;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DecimalTextField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.DisplayNameArrowKeyBlockingChoiceBox;
import com.deutscheboerse.comxerv.comtrader.jfx.components.settings.SettingsSection;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfiguration;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.OverrideGuiConfigurationsExecutor;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui.AllDescendantsByIdOverrideGuiStrategy;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MainPanelService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.Theme;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlash;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.ColorFlashFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.service.flash.FlashDuration;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.ColorThemeService;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.FontService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.converter.DisplayNameConverter;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.FutureExecutor;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.binding.DependentBinding;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javafx.beans.Observable;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.GridPane;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@OverrideGuiConfiguration(field="#this", overrideId="GeneralSettingsPane", strategy=AllDescendantsByIdOverrideGuiStrategy.class)
public class GeneralSettingsPane
extends GridPane
implements SettingsSection {
    private static final Logger LOG = LoggerFactory.getLogger(GeneralSettingsPane.class);
    public static final SettingsService.Settings<Long> CAPACITY_THRESHOLD = new SettingsService.Settings<Long>("capacity-threshold", -1L);
    private final ApplicationContext appContext;
    private final UserAlertService userAlertService;
    private final ColorThemeService colorThemeService;
    private final LocalService localService;
    private final ColorFlashFactory colorFlashFactory;
    private final FontService fontService;
    private final SettingsService settingsService;
    @FXML
    private ChoiceBox<Locale> languageChoice;
    @FXML
    private ChoiceBox<Theme> themeChoice;
    @FXML
    private ChoiceBox<FlashDuration> flashDurationChoice;
    @FXML
    private Label flashPreviewRectangle;
    @FXML
    private DisplayNameArrowKeyBlockingChoiceBox<JodaDateFormatType> dateFormatChoiceBox;
    @FXML
    private CheckBox enableGroupingSeparatorCheckBox;
    @FXML
    private DisplayNameArrowKeyBlockingChoiceBox<NumberStyleType> numberStyleChoiceBox;
    @FXML
    private Label numberStyleExampleLabel;
    private ColorFlash colorFlash;
    @FXML
    private DecimalTextField capacityThreshold;
    @FXML
    private Button removeThemeButton;
    @FXML
    private Button loadThemeButton;
    @FXML
    private Button loadBundleButton;
    @FXML
    private MenuButton fontSizeMenuButton;
    @FXML
    private MenuButton fontFamilyMenuButton;
    @FXML
    private MenuButton cellPaddingMenuButton;
    @FXML
    private MenuButton verticalBorderMenuButton;
    @FXML
    private MenuButton horizontalBorderMenuButton;
    @FXML
    private MenuButton panelDividerMenuButton;
    private SimpleObjectProperty<FlashDuration> selectedDurationProperty;
    private FontService.FontSize selectedFontSize;
    private FontService.FontFamily selectedFontFamily;
    private FontService.VerticalBorder selectedVerticalBorder;
    private FontService.HorizontalBorder selectedHorizontalBorder;
    private FontService.CellPadding selectedCellPadding;
    private FontService.PanelDivider selectedPanelDivider;
    private FutureExecutor asyncGuiUpdatesExecutor;

    public GeneralSettingsPane() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public GeneralSettingsPane(ApplicationContext appContext) {
        this.appContext = appContext;
        this.localService = appContext.getService(LocalService.class);
        this.colorThemeService = appContext.getService(ColorThemeService.class);
        this.userAlertService = appContext.getService(UserAlertService.class);
        this.colorFlashFactory = appContext.getService(ColorFlashFactory.class);
        this.fontService = appContext.getService(FontService.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.asyncGuiUpdatesExecutor = new FutureExecutor(appContext.getService(ScheduledExecutorService.class, WorkerExecutor.class));
        FXMLLoaderWithContext.loadCustomComponent(appContext, this);
    }

    public void initialize() {
        Locale currentLocale = Util.getCurrentOrDefaultLocale();
        HashSet<Locale> availableLanguages = new HashSet<Locale>(this.localService.getAvailableLanguages());
        this.languageChoice.getItems().addAll((Collection<Locale>)availableLanguages);
        if (availableLanguages.contains(currentLocale)) {
            this.languageChoice.setValue(currentLocale);
        } else {
            this.languageChoice.setValue(availableLanguages.stream().filter(locale -> locale.getLanguage().equals(currentLocale.getLanguage())).findFirst().orElse(null));
        }
        FXCollections.sort(this.languageChoice.getItems(), Comparator.comparing(Locale::getLanguage));
        this.languageChoice.setConverter(new StringConverter<Locale>(this){

            @Override
            public String toString(Locale locale) {
                return locale.getDisplayLanguage(locale);
            }

            @Override
            public Locale fromString(String s) {
                throw new UnsupportedOperationException();
            }
        });
        this.flashDurationChoice.setConverter(new DisplayNameConverter());
        this.flashDurationChoice.getItems().addAll((FlashDuration[])FlashDuration.values());
        this.flashDurationChoice.setValue(this.colorFlashFactory.getFlashDuration());
        this.selectedDurationProperty = new SimpleObjectProperty<FlashDuration>(this.flashDurationChoice.getValue());
        this.colorFlash = this.colorFlashFactory.getFlash(this.flashPreviewRectangle, this.selectedDurationProperty);
        this.flashDurationChoice.valueProperty().addListener((observableValue, oldValue, newValue) -> {
            this.selectedDurationProperty.setValue((FlashDuration)newValue);
            this.colorFlash.flash();
        });
        this.loadThemeChoiceBoxItems(this.colorThemeService.getConfiguredTheme());
        this.themeChoice.setConverter(new DisplayNameConverter());
        this.removeThemeButton.visibleProperty().bind(DependentBinding.get(Theme::isDeletable, this.themeChoice.valueProperty()));
        ObservableList<JodaDateFormatType> dateFormatList = FXCollections.observableArrayList();
        dateFormatList.addAll(JodaDateFormatType.values());
        this.dateFormatChoiceBox.setListedItems(dateFormatList);
        this.numberStyleChoiceBox.setListedItems(EnumSet.allOf(NumberStyleType.class));
        this.numberStyleExampleLabel.textProperty().bind(new DependentBinding<String>(new Observable[]{this.enableGroupingSeparatorCheckBox.selectedProperty(), this.numberStyleChoiceBox.valueProperty()}){

            @Override
            protected String computeValue() {
                if (GeneralSettingsPane.this.numberStyleChoiceBox.getValue() != null) {
                    LongDisplayValue longDisplayValue = new LongDisplayValue(999966L, 2);
                    return ((NumberStyleType)GeneralSettingsPane.this.numberStyleChoiceBox.getValue()).format(longDisplayValue.getDisplayValue(), GeneralSettingsPane.this.enableGroupingSeparatorCheckBox.isSelected());
                }
                return "";
            }
        });
        this.loadFontMenuButtons();
        this.loadSettings();
        this.appContext.getService(OverrideGuiConfigurationsExecutor.class).registerAndApply(this);
    }

    private void loadFontMenuButtons() {
        for (FontService.FontSize fontSize : FontService.FontSize.values()) {
            MenuItem fontSizeMenuItem = new MenuItem(fontSize.getDisplayName());
            fontSizeMenuItem.setStyle("-fx-font-size: " + fontSize.getFontSize());
            fontSizeMenuItem.setOnAction(event -> this.setSelectedFontSize(fontSize));
            this.fontSizeMenuButton.getItems().add(fontSizeMenuItem);
        }
        for (Enum enum_ : FontService.FontFamily.values()) {
            MenuItem fontFamilyMenuItem = new MenuItem(((FontService.FontFamily)enum_).getDisplayName());
            fontFamilyMenuItem.setStyle("-fx-font-family: " + ((FontService.FontFamily)enum_).getCssName());
            fontFamilyMenuItem.setOnAction(arg_0 -> this.lambda$loadFontMenuButtons$3((FontService.FontFamily)enum_, arg_0));
            this.fontFamilyMenuButton.getItems().add(fontFamilyMenuItem);
        }
        for (Enum enum_ : FontService.CellPadding.values()) {
            MenuItem cellPaddingMenuItem = new MenuItem(((FontService.CellPadding)enum_).getDisplayName());
            cellPaddingMenuItem.setOnAction(arg_0 -> this.lambda$loadFontMenuButtons$4((FontService.CellPadding)enum_, arg_0));
            this.cellPaddingMenuButton.getItems().add(cellPaddingMenuItem);
        }
        for (Enum enum_ : FontService.VerticalBorder.values()) {
            MenuItem verticalBorderMenuItem = new MenuItem(((FontService.VerticalBorder)enum_).getDisplayName());
            verticalBorderMenuItem.setOnAction(arg_0 -> this.lambda$loadFontMenuButtons$5((FontService.VerticalBorder)enum_, arg_0));
            this.verticalBorderMenuButton.getItems().add(verticalBorderMenuItem);
        }
        for (Enum enum_ : FontService.HorizontalBorder.values()) {
            MenuItem horizontalBorderMenuItem = new MenuItem(((FontService.HorizontalBorder)enum_).getDisplayName());
            horizontalBorderMenuItem.setOnAction(arg_0 -> this.lambda$loadFontMenuButtons$6((FontService.HorizontalBorder)enum_, arg_0));
            this.horizontalBorderMenuButton.getItems().add(horizontalBorderMenuItem);
        }
        for (Enum enum_ : FontService.PanelDivider.values()) {
            MenuItem panelDividerMenuItem = new MenuItem(((FontService.PanelDivider)enum_).getDisplayName());
            panelDividerMenuItem.setOnAction(arg_0 -> this.lambda$loadFontMenuButtons$7((FontService.PanelDivider)enum_, arg_0));
            this.panelDividerMenuButton.getItems().add(panelDividerMenuItem);
        }
    }

    private void loadThemeChoiceBoxItems(Theme theme) {
        ArrayList<Theme> selectableThemes = new ArrayList<Theme>(this.colorThemeService.getAvailableThemes());
        Collections.sort(selectableThemes, Comparator.comparing(Theme::getName));
        this.themeChoice.getItems().clear();
        this.themeChoice.getItems().addAll((Collection<Theme>)FXCollections.observableArrayList(selectableThemes));
        FxUtil.runLater(() -> {
            if (this.themeChoice.getItems().contains(theme)) {
                this.themeChoice.setValue(theme);
            } else {
                this.themeChoice.setValue(this.colorThemeService.getDefaultTheme());
            }
            this.themeChoice.requestLayout();
        });
    }

    @Override
    public boolean applyChanges() {
        boolean uiReloadNeeded;
        Theme selectedTheme;
        Locale selectedLocale = this.languageChoice.getValue();
        if (this.hasLanguageChanged()) {
            this.localService.storeConfiguredLocale(selectedLocale);
            this.appContext.getService(MainPanelService.class).requestCompleteUiRefresh();
        }
        if ((selectedTheme = this.themeChoice.getValue()) != null) {
            this.colorThemeService.storeConfiguredTheme(selectedTheme);
        }
        this.colorThemeService.switchToTheme(selectedTheme);
        if (this.hasFontFamilyChanged() || this.hasFontSizeChanged()) {
            this.fontService.setFontSize(this.selectedFontSize);
            this.fontService.setFontFamily(this.selectedFontFamily);
        }
        if (this.hasCellPaddingChanged()) {
            this.fontService.setCellPadding(this.selectedCellPadding);
        }
        if (this.hasVerticalBorderChanged()) {
            this.fontService.setVerticalBorder(this.selectedVerticalBorder);
        }
        if (this.hasHorizontalBorderChanged()) {
            this.fontService.setHorizontalBorder(this.selectedHorizontalBorder);
        }
        if (this.hasPanelDividerChanged()) {
            this.fontService.setPanelDivider(this.selectedPanelDivider);
        }
        boolean bl = uiReloadNeeded = this.hasGroupingSeparatorChange() || this.hasNumberFormatChanged() || this.hasDateFormatChanged() || this.hasFlashDurationChanged() || this.hasCapacityThresholdChanged();
        if (uiReloadNeeded) {
            this.localService.storeGroupingSeparatorEnabled(this.enableGroupingSeparatorCheckBox.isSelected());
            this.localService.storeNumberStyleType((NumberStyleType)this.numberStyleChoiceBox.getValue());
            this.localService.storeJodaDateFormat((JodaDateFormatType)this.dateFormatChoiceBox.getValue());
            this.colorFlashFactory.storeFlashDuration(this.flashDurationChoice.getValue());
            this.settingsService.storeSettings(CAPACITY_THRESHOLD, this.getThreshold());
            this.appContext.getService(MainPanelService.class).requestCompleteUiRefresh();
        }
        return true;
    }

    private boolean hasGroupingSeparatorChange() {
        return this.localService.isGroupingSeparatorEnabled() != this.enableGroupingSeparatorCheckBox.isSelected();
    }

    private boolean hasNumberFormatChanged() {
        return !this.localService.getNumberStyleType().equals(this.numberStyleChoiceBox.getValue());
    }

    private boolean hasDateFormatChanged() {
        return !this.localService.getJodaDateFormat().equals(this.dateFormatChoiceBox.getValue());
    }

    @Override
    public void cancelChanges() {
        this.loadThemeChoiceBoxItems(this.colorThemeService.getConfiguredTheme());
        this.flashDurationChoice.setValue(this.colorFlashFactory.getFlashDuration());
        this.loadSettings();
        Long threshold = this.settingsService.loadSettings(CAPACITY_THRESHOLD);
        if (threshold == null || threshold.equals(-1L)) {
            this.capacityThreshold.clear();
        } else {
            this.capacityThreshold.setText(new LongDisplayValue(threshold, 3).toString());
        }
    }

    @Override
    public void resetToDefault() {
        this.loadThemeChoiceBoxItems(this.colorThemeService.getDefaultTheme());
        this.flashDurationChoice.setValue(ColorFlashFactory.DEFAULT_FLASH_DURATION);
        this.numberStyleChoiceBox.setValue(LocalService.DEFAULT_NUMBER_STYLE);
        this.enableGroupingSeparatorCheckBox.setSelected(false);
        this.dateFormatChoiceBox.setValue(LocalService.DEFAULT_JODA_TIME_FORMAT);
        this.setSelectedFontSize(FontService.DEFAULT_FONT_SIZE);
        this.setSelectedFontFamily(FontService.DEFAULT_FONT_FAMILY);
        this.setSelectedCellPadding(FontService.DEFAULT_CELL_PADDING);
        this.setSelectedVerticalBorder(FontService.DEFAULT_VERTICAL_BORDER);
        this.setSelectedHorizontalBorder(FontService.DEFAULT_HORIZONTAL_BORDER);
        this.setSelectedPanelDivider(FontService.DEFAULT_PANEL_DEVIDER);
        this.capacityThreshold.clear();
    }

    public void loadSettings() {
        this.numberStyleChoiceBox.setValue(this.localService.getNumberStyleType());
        this.enableGroupingSeparatorCheckBox.setSelected(this.localService.isGroupingSeparatorEnabled());
        this.dateFormatChoiceBox.setValue(this.localService.getJodaDateFormat());
        this.setSelectedFontSize(this.fontService.getFontSize());
        this.setSelectedFontFamily(this.fontService.getFontFamily());
        this.setSelectedCellPadding(this.fontService.getCellPadding());
        this.setSelectedVerticalBorder(this.fontService.getVerticalBorder());
        this.setSelectedHorizontalBorder(this.fontService.getHorizontalBorder());
        this.setSelectedPanelDivider(this.fontService.getPanelDivider());
    }

    @FXML
    public void loadBundle() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter propsFilter = new FileChooser.ExtensionFilter(Util.getLabel("settingsPanel_generalTab_propertiesFilesFilter"), "*.properties");
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_allFiles"), "*.*");
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{propsFilter, allFilter});
        File sourceFile = fileChooser.showOpenDialog(null);
        if (sourceFile != null) {
            Future<Locale> loadCustomLocale = this.localService.loadCustomBundle(sourceFile);
            this.asyncGuiUpdatesExecutor.waitForFutureToComplete(loadCustomLocale, this::customBundleLoaded, this::customBundleLoadingFailed);
        }
    }

    private void customBundleLoaded(Locale locale) {
        FxUtil.runInFxThread(() -> {
            if (!this.languageChoice.getItems().contains(locale)) {
                this.languageChoice.getItems().add(locale);
            }
            this.languageChoice.setValue(locale);
        });
    }

    private void customBundleLoadingFailed(Exception exception) {
        this.userAlertService.showConfirmationDialog(Util.getLabel("commons_error"), Util.getLabel("commons_error"), exception.getMessage(), UserAlertService.Flag.ERROR);
        LOG.error("Could not load custom bundle", exception);
    }

    @FXML
    public void loadTheme() {
        FileChooser fileChooser = new FileChooser();
        FileChooser.ExtensionFilter cssFilter = new FileChooser.ExtensionFilter(Util.getLabel("settingsPanel_generalTab_cssFilesFilter"), "*.css", "*.CSS");
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter(Util.getLabel("commons_allFiles"), "*.*");
        fileChooser.getExtensionFilters().addAll((FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{cssFilter, allFilter});
        File sourceFile = fileChooser.showOpenDialog(null);
        if (sourceFile != null) {
            try {
                Theme newCustomTheme = this.colorThemeService.addCustomTheme(sourceFile);
                this.colorThemeService.switchToTheme(newCustomTheme);
                this.loadThemeChoiceBoxItems(this.colorThemeService.getCurrentTheme());
            }
            catch (IOException exception) {
                this.userAlertService.showConfirmationDialog("error", "error", UserAlertService.Flag.ERROR);
            }
        }
    }

    @FXML
    public void playPreview() {
        this.colorFlash.flash();
    }

    @FXML
    public void removeTheme() {
        Theme themeToRemove = this.themeChoice.getValue();
        this.themeChoice.setValue(this.colorThemeService.getDefaultTheme());
        this.colorThemeService.removeCustomTheme(themeToRemove);
        this.loadThemeChoiceBoxItems(this.colorThemeService.getCurrentTheme());
    }

    private boolean hasLanguageChanged() {
        return !Objects.equals(this.languageChoice.getValue(), Util.getCurrentLocale());
    }

    private boolean hasFlashDurationChanged() {
        return !Objects.equals(this.flashDurationChoice.getValue(), this.colorFlashFactory.getFlashDuration());
    }

    private boolean hasFontSizeChanged() {
        return this.fontService.getFontSize() != this.selectedFontSize;
    }

    private boolean hasFontFamilyChanged() {
        return this.fontService.getFontFamily() != this.selectedFontFamily;
    }

    private boolean hasCellPaddingChanged() {
        return this.fontService.getCellPadding() != this.selectedCellPadding;
    }

    private boolean hasVerticalBorderChanged() {
        return this.fontService.getVerticalBorder() != this.selectedVerticalBorder;
    }

    private boolean hasHorizontalBorderChanged() {
        return this.fontService.getHorizontalBorder() != this.selectedHorizontalBorder;
    }

    private boolean hasPanelDividerChanged() {
        return this.fontService.getPanelDivider() != this.selectedPanelDivider;
    }

    private boolean hasCapacityThresholdChanged() {
        return !Objects.equals(this.settingsService.loadSettings(CAPACITY_THRESHOLD), this.getThreshold());
    }

    private void setSelectedFontFamily(FontService.FontFamily selectedFontFamily) {
        this.selectedFontFamily = selectedFontFamily;
        this.fontFamilyMenuButton.setText(selectedFontFamily.getDisplayName());
        this.fontFamilyMenuButton.setStyle("-fx-font-family: " + selectedFontFamily.getCssName());
    }

    private void setSelectedFontSize(FontService.FontSize selectedFontSize) {
        this.selectedFontSize = selectedFontSize;
        this.fontSizeMenuButton.setText(selectedFontSize.getDisplayName());
        this.fontSizeMenuButton.setStyle("-fx-font-size: " + selectedFontSize.getFontSize());
    }

    private void setSelectedVerticalBorder(FontService.VerticalBorder selectedVerticalBorder) {
        this.selectedVerticalBorder = selectedVerticalBorder;
        this.verticalBorderMenuButton.setText(selectedVerticalBorder.getDisplayName());
    }

    private void setSelectedHorizontalBorder(FontService.HorizontalBorder selectedHorizontalBorder) {
        this.selectedHorizontalBorder = selectedHorizontalBorder;
        this.horizontalBorderMenuButton.setText(selectedHorizontalBorder.getDisplayName());
    }

    private void setSelectedCellPadding(FontService.CellPadding selectedCellPadding) {
        this.selectedCellPadding = selectedCellPadding;
        this.cellPaddingMenuButton.setText(selectedCellPadding.getDisplayName());
    }

    private void setSelectedPanelDivider(FontService.PanelDivider panelDivider) {
        this.selectedPanelDivider = panelDivider;
        this.panelDividerMenuButton.setText(panelDivider.getDisplayName());
    }

    private long getThreshold() {
        return this.capacityThreshold.getValue().map(LongDisplayValue::getValue).orElse(-1L);
    }

    private /* synthetic */ void lambda$loadFontMenuButtons$7(FontService.PanelDivider panelDivider, ActionEvent event) {
        this.setSelectedPanelDivider(panelDivider);
    }

    private /* synthetic */ void lambda$loadFontMenuButtons$6(FontService.HorizontalBorder horizontalBorder, ActionEvent event) {
        this.setSelectedHorizontalBorder(horizontalBorder);
    }

    private /* synthetic */ void lambda$loadFontMenuButtons$5(FontService.VerticalBorder verticalBorder, ActionEvent event) {
        this.setSelectedVerticalBorder(verticalBorder);
    }

    private /* synthetic */ void lambda$loadFontMenuButtons$4(FontService.CellPadding cellPadding, ActionEvent event) {
        this.setSelectedCellPadding(cellPadding);
    }

    private /* synthetic */ void lambda$loadFontMenuButtons$3(FontService.FontFamily fontFamily, ActionEvent event) {
        this.setSelectedFontFamily(fontFamily);
    }
}

