/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.msgrecorder;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.GuiMessageRecorder;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.jfx.service.style.StyleService;
import com.deutscheboerse.comxerv.comtrader.util.XmlFormatterUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class ShowAmqpMessageBodyCellCustomizer
extends GenericCellCustomizer<GuiMessageRecorder.AmqpMessage, String> {
    private static final Pattern XML_TAG = Pattern.compile("(?<ELEMENT>(</?\\h*)(\\w+)([^<>]*)(\\h*/?>))|(?<COMMENT><!--[^<>]+-->)");
    private static final Pattern ATTRIBUTES = Pattern.compile("(\\w+\\h*)(=)(\\h*\"[^\"]+\")");
    private static final int GROUP_OPEN_BRACKET = 2;
    private static final int GROUP_ELEMENT_NAME = 3;
    private static final int GROUP_ATTRIBUTES_SECTION = 4;
    private static final int GROUP_CLOSE_BRACKET = 5;
    private static final int GROUP_ATTRIBUTE_NAME = 1;
    private static final int GROUP_EQUAL_SYMBOL = 2;
    private static final int GROUP_ATTRIBUTE_VALUE = 3;
    private final StyleService styleService;

    public ShowAmqpMessageBodyCellCustomizer() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public ShowAmqpMessageBodyCellCustomizer(ApplicationContext applicationContext) {
        this.styleService = applicationContext.getService(StyleService.class);
    }

    @Override
    protected Node getGraphic(String cellItem, GuiMessageRecorder.AmqpMessage rowValue, Node defaultGraphic) {
        ButtonWithIcon button = new ButtonWithIcon("", "button-search");
        button.setOnAction(event -> this.showMessageBody(cellItem, rowValue.getType()));
        return button;
    }

    private void showMessageBody(String messageBody, String messageType) {
        Stage detailStage = new Stage(StageStyle.DECORATED);
        detailStage.addEventFilter(KeyEvent.KEY_PRESSED, t -> {
            if (t.getCode() == KeyCode.ESCAPE) {
                detailStage.close();
                t.consume();
            }
        });
        detailStage.initModality(Modality.NONE);
        this.styleService.registerWindowForStyleSwitching(detailStage);
        CodeArea codeArea = new CodeArea();
        codeArea.setParagraphGraphicFactory(LineNumberFactory.get(codeArea));
        codeArea.setEditable(false);
        codeArea.setWrapText(true);
        codeArea.textProperty().addListener((obs, oldText, newText) -> codeArea.setStyleSpans(0, ShowAmqpMessageBodyCellCustomizer.computeHighlighting(newText)));
        codeArea.replaceText(0, 0, XmlFormatterUtil.formatXML(messageBody));
        BorderPane borderPane = this.prepareBorderPane(codeArea);
        Scene scene = new Scene(borderPane, 600.0, 300.0);
        detailStage.setScene(scene);
        detailStage.setTitle(messageType);
        detailStage.show();
    }

    BorderPane prepareBorderPane(CodeArea codeArea) {
        BorderPane borderPane = new BorderPane();
        borderPane.centerProperty().setValue(new VirtualizedScrollPane<CodeArea>(codeArea));
        return borderPane;
    }

    public static StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = XML_TAG.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        while (matcher.find()) {
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            if (matcher.group("COMMENT") != null) {
                spansBuilder.add(Collections.singleton("syntaxHighlighting_comment"), matcher.end() - matcher.start());
            } else if (matcher.group("ELEMENT") != null) {
                String attributesText = matcher.group(4);
                spansBuilder.add(Collections.singleton("syntaxHighlighting_tagmark"), matcher.end(2) - matcher.start(2));
                spansBuilder.add(Collections.singleton("syntaxHighlighting_anytag"), matcher.end(3) - matcher.end(2));
                if (!attributesText.isEmpty()) {
                    lastKwEnd = 0;
                    Matcher amatcher = ATTRIBUTES.matcher(attributesText);
                    while (amatcher.find()) {
                        spansBuilder.add(Collections.emptyList(), amatcher.start() - lastKwEnd);
                        spansBuilder.add(Collections.singleton("syntaxHighlighting_attribute"), amatcher.end(1) - amatcher.start(1));
                        spansBuilder.add(Collections.singleton("syntaxHighlighting_tagmark"), amatcher.end(2) - amatcher.end(1));
                        spansBuilder.add(Collections.singleton("syntaxHighlighting_avalue"), amatcher.end(3) - amatcher.end(2));
                        lastKwEnd = amatcher.end();
                    }
                    if (attributesText.length() > lastKwEnd) {
                        spansBuilder.add(Collections.emptyList(), attributesText.length() - lastKwEnd);
                    }
                }
                lastKwEnd = matcher.end(4);
                spansBuilder.add(Collections.singleton("syntaxHighlighting_tagmark"), matcher.end(5) - lastKwEnd);
            }
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }
}

