/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.table.trade;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.FullTradeQueries;
import com.deutscheboerse.comxerv.comtrader.domain.query.HalfTradeQueries;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.entities.HalfTrade;
import com.deutscheboerse.comxerv.comtrader.entities.Trade;
import com.deutscheboerse.comxerv.comtrader.jfx.FXMLLoaderWithContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.ButtonWithIcon;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.CustomTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellCustomizer;
import com.deutscheboerse.comxerv.comtrader.jfx.components.table.storage.StorableTableLayoutDescriptor;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.DecomposedTradesPopup;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.FullTradesTableView;
import com.deutscheboerse.comxerv.comtrader.jfx.components.trade.HalfTradesTableView;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.TableView;

public class DecomposedCellCustomizer<T extends Trade>
extends GenericCellCustomizer<T, Boolean> {
    private final ApplicationContext applicationContext;
    private final ObjectProperty<TableView<T>> tradeTableView;

    public DecomposedCellCustomizer() {
        this(FXMLLoaderWithContext.getAppContext());
    }

    public DecomposedCellCustomizer(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.tradeTableView = new SimpleObjectProperty<TableView<T>>();
    }

    @Override
    protected Node getGraphic(Boolean cellItem, T rowValue, Node defaultGraphic) {
        if (cellItem.booleanValue()) {
            ButtonWithIcon buttonWithIcon = new ButtonWithIcon("", "button-search");
            if (rowValue instanceof FullTrade) {
                buttonWithIcon.setOnAction(event -> this.showFullTradePopup((FullTrade)rowValue));
            } else if (rowValue instanceof HalfTrade) {
                buttonWithIcon.setOnAction(event -> this.showHalfTradePopup((HalfTrade)rowValue));
            }
            return buttonWithIcon;
        }
        return null;
    }

    private void showHalfTradePopup(HalfTrade halfTrade) {
        HalfTradesTableView halfTradesTableView = new HalfTradesTableView(this.applicationContext);
        this.applicationContext.getService(HalfTradeQueries.class).findByParentTradeId(halfTrade.getTradeId()).addFilter(t -> t.getDirection() == halfTrade.getDirection()).getAll().forEach(halfTradesTableView.getItems()::add);
        this.adjustTableViewLook(halfTradesTableView);
        this.showPopup(halfTradesTableView, Util.getLabel("commons_decomposed"));
    }

    private void showFullTradePopup(FullTrade fullTrade) {
        FullTradesTableView fullTradesTableView = new FullTradesTableView(this.applicationContext);
        this.applicationContext.getService(FullTradeQueries.class).findByParentTradeId((Long)fullTrade.getId()).getAll().forEach(fullTradesTableView.getItems()::add);
        this.adjustTableViewLook(fullTradesTableView);
        this.showPopup(fullTradesTableView, Util.getLabel("commons_decomposed"));
    }

    private void showPopup(TableView decomposedTradeTableView, String title) {
        this.applicationContext.getService(DecomposedTradesPopup.class).show(decomposedTradeTableView, title);
    }

    private void adjustTableViewLook(CustomTableView tableView) {
        StorableTableLayoutDescriptor.fromTable((TableView)this.tradeTableView.get()).applyToTable(tableView);
        tableView.setPrefHeight(((TableView)this.tradeTableView.get()).getFixedCellSize() * (double)(tableView.getItems().size() + 2));
    }

    public TableView<T> getTradeTableView() {
        return (TableView)this.tradeTableView.get();
    }

    public ObjectProperty<TableView<T>> tradeTableViewProperty() {
        return this.tradeTableView;
    }

    public void setTradeTableView(TableView<T> tradeTableView) {
        this.tradeTableView.set(tradeTableView);
    }
}

