/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.components.tree;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.WeakDataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ContractFilters;
import com.deutscheboerse.comxerv.comtrader.domain.filter.ProductFilters;
import com.deutscheboerse.comxerv.comtrader.domain.query.ContractQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.Product;
import com.deutscheboerse.comxerv.comtrader.jfx.components.FXMLBorderPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.control.SimpleLongDisplayValueField;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTreeCellFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.ContractTreeContext;
import com.deutscheboerse.comxerv.comtrader.jfx.components.tree.SearchBox;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class ContractTree
extends FXMLBorderPane {
    private final AbstractDataModelListener<Product> productListener;
    private final AbstractDataModelListener<Contract> contractListener;
    private static final Comparator<TreeItem<Object>> TREE_ITEM_COMPARATOR = new ContractTreeItemComparator();
    private final ContractTreeContext contractTreeContext;
    private final ContractQueries contractQueries;
    @FXML
    private SearchBox searchBox;
    @FXML
    private VBox headerContainer;
    @FXML
    private TreeView<Object> treeView;
    private final TreeItem<Object> root;
    private Map<Product, SimpleLongDisplayValueField> productStepSizes = new HashMap<Product, SimpleLongDisplayValueField>();
    private final BooleanProperty hasValidProductStepSizes = new SimpleBooleanProperty();

    public ContractTree(ApplicationContext appContext, ContractTreeContext contractTreeContext) {
        super(appContext);
        this.contractTreeContext = contractTreeContext;
        this.contractQueries = appContext.getService(ContractQueries.class);
        this.root = new TreeItem();
        this.loadFxml();
        this.treeView.setCellFactory(new ContractTreeCellFactory(appContext, contractTreeContext, this.productStepSizes));
        this.productListener = new AbstractDataModelListener<Product>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Product product) {
                return ContractTree.this.productAdded(product);
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Product product) {
                return ContractTree.this.productUpdated(product);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Product object) {
                return ContractTree.this.productRemoved(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return ContractTree.this.productsRemoved();
            }
        };
        this.contractListener = new AbstractDataModelListener<Contract>(){

            @Override
            public DataModelListener.NotificationResult notifyAdd(Contract object) {
                return ContractTree.this.contractAdded(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyUpdate(Contract object) {
                return ContractTree.this.contractUpdated(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemove(Contract object) {
                return ContractTree.this.contractRemoved(object);
            }

            @Override
            public DataModelListener.NotificationResult notifyRemoveAll() {
                return ContractTree.this.contractsRemoved();
            }
        };
        this.populateTreeView();
        this.searchBox.searchFilterProperty().addListener((observable2, oldValue, newValue) -> this.refilter((Optional<Predicate<Object>>)newValue));
    }

    public void initialize() {
        if (this.contractTreeContext.areProductsSteppable()) {
            HBox hBoxContainer = new HBox(new Label(Util.getLabel("commons_stepSize")));
            hBoxContainer.setAlignment(Pos.CENTER_RIGHT);
            this.headerContainer.getChildren().add(hBoxContainer);
        }
    }

    public BooleanProperty hasValidProductStepSizesProperty() {
        return this.hasValidProductStepSizes;
    }

    private void refilter(Optional<Predicate<Object>> newValue) {
        if (newValue.isPresent()) {
            this.treeView.setRoot(this.copyFiltered(this.root, newValue.get()));
        } else {
            this.treeView.setRoot(this.root);
        }
    }

    public void productAddForStepSize(Product product) {
        if (this.contractTreeContext.areProductsSteppable()) {
            SimpleLongDisplayValueField priceStepField = new SimpleLongDisplayValueField();
            priceStepField.setValue(product.getPriceTickSize());
            priceStepField.setMinimum(product.getPriceMinValue());
            priceStepField.setMaximum(product.getPriceMaxValue());
            priceStepField.setDelta((int)product.getPriceTickSize().getValue());
            priceStepField.validProperty().addListener(observable2 -> this.recalcuteValidStepSizes());
            this.productStepSizes.put(product, priceStepField);
        }
    }

    private void recalcuteValidStepSizes() {
        for (SimpleLongDisplayValueField longDisplayValueField : this.productStepSizes.values()) {
            if (longDisplayValueField.isValid()) continue;
            this.hasValidProductStepSizes.setValue(Boolean.FALSE);
            return;
        }
        this.hasValidProductStepSizes.setValue(Boolean.TRUE);
    }

    public Map<Product, SimpleLongDisplayValueField> getProductStepSizes() {
        return this.productStepSizes;
    }

    private TreeItem<Object> copyFiltered(TreeItem<Object> item, Predicate<Object> filter) {
        TreeItem<Object> filteredCopy = new TreeItem<Object>(item.getValue());
        filteredCopy.setExpanded(item.isExpanded());
        item.getChildren().stream().filter(child -> filter.test(child.getValue())).map(matchingChild -> this.copyFiltered((TreeItem<Object>)matchingChild, filter)).forEach(filteredCopy.getChildren()::add);
        return filteredCopy;
    }

    private DataModelListener.NotificationResult productAdded(Product product) {
        if (this.shouldBeDisplayed(product) && !this.alreadyInTree(product)) {
            this.root.getChildren().add(new TreeItem<Product>(product));
            FXCollections.sort(this.root.getChildren(), TREE_ITEM_COMPARATOR);
            this.contractQueries.findByProduct(product).getAll().forEach(this::contractAdded);
            this.productAddForStepSize(product);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult productUpdated(Product product) {
        if (this.shouldBeDisplayed(product)) {
            this.productAdded(product);
        } else {
            this.productRemoved(product);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult productsRemoved() {
        this.getProductItemsStream().filter(item -> item.getValue() instanceof Product).toList().forEach(this.root.getChildren()::remove);
        this.productStepSizes.clear();
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    private DataModelListener.NotificationResult productRemoved(Product product) {
        this.getProductItemsStream().filter(item -> item.getValue().equals(product)).findAny().ifPresent(this.root.getChildren()::remove);
        this.contractTreeContext.productUnsubscribed(product);
        this.productStepSizes.remove(product);
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult contractUpdated(Contract object) {
        if (this.shouldBeDisplayed(object)) {
            this.contractAdded(object);
        } else {
            this.contractRemoved(object);
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult contractAdded(Contract object) {
        if (this.shouldBeDisplayed(object) && !this.alreadyInTree(object)) {
            this.getProductItemsStream().filter(item -> object.getProduct().equals(item.getValue())).findFirst().ifPresent(productItem -> {
                productItem.getChildren().add(new TreeItem<Contract>(object));
                FXCollections.sort(productItem.getChildren(), TREE_ITEM_COMPARATOR);
            });
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private DataModelListener.NotificationResult contractsRemoved() {
        this.getContractItems().stream().filter(item -> item.getValue() instanceof Contract).forEach(item -> item.getParent().getChildren().remove(item));
        return DataModelListener.NotificationResult.REMOVE_LISTENER;
    }

    private DataModelListener.NotificationResult contractRemoved(Contract object) {
        this.getContractItems().stream().filter(item -> object.equals(item.getValue())).forEach(item -> item.getParent().getChildren().remove(item));
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private boolean alreadyInTree(Contract contract) {
        return this.getContractItemsStream().map(TreeItem::getValue).anyMatch(contract::equals);
    }

    private boolean alreadyInTree(Product product) {
        return this.getProductItemsStream().map(TreeItem::getValue).anyMatch(product::equals);
    }

    private Stream<TreeItem<Object>> getContractItemsStream() {
        return this.getProductItemsStream().flatMap(item -> item.getChildren().stream());
    }

    private Stream<TreeItem<Object>> getProductItemsStream() {
        return this.root.getChildren().stream();
    }

    private List<TreeItem<Object>> getContractItems() {
        return this.getContractItemsStream().toList();
    }

    private boolean shouldBeDisplayed(Product product) {
        return this.contractTreeContext.getProductFilter().and(ProductFilters.ONLY_ACTIVE).test(product);
    }

    private boolean shouldBeDisplayed(Contract contract) {
        return this.contractTreeContext.getContractFilter().and(ContractFilters.NOT_INACTIVE).test(contract);
    }

    private void populateTreeView() {
        this.treeView.setRoot(this.root);
        this.getAppContext().getSmallDataModel(Product.class).registerListener(new WeakDataModelListener<Product>(this.productListener));
        this.getAppContext().getSmallDataModel(Contract.class).registerListener(new WeakDataModelListener<Contract>(this.contractListener));
    }

    public void expandAll() {
        this.root.getChildren().forEach(item -> item.setExpanded(true));
    }

    public void collapseAll() {
        this.root.getChildren().forEach(item -> item.setExpanded(false));
    }

    private static class ContractTreeItemComparator
    implements Comparator<TreeItem<Object>> {
        private ContractTreeItemComparator() {
        }

        @Override
        public int compare(TreeItem<Object> item1, TreeItem<Object> item2) {
            Object value1 = item1.getValue();
            Object value2 = item2.getValue();
            if (value1 instanceof Contract && value2 instanceof Contract) {
                return Contract.DEFAULT_COMPARATOR.compare((Contract)value1, (Contract)value2);
            }
            if (value1 instanceof Product && value2 instanceof Product) {
                return ((Product)value1).getDisplayName().compareTo(((Product)value2).getDisplayName());
            }
            return 0;
        }
    }
}

