/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.overrides.strategy.gui;

import com.deutscheboerse.comxerv.comtrader.jfx.overrides.functional.FieldIdentifierValueResolver;
import com.deutscheboerse.comxerv.comtrader.jfx.overrides.functional.FieldsToOverrideResolver;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class AbstractOverrideGuiStrategy<T, S> {
    private final FieldsToOverrideResolver<T, S> fieldsToOverrideResolver;
    private final FieldIdentifierValueResolver<S> fieldIdentifierValueResolver;

    protected AbstractOverrideGuiStrategy(FieldsToOverrideResolver<T, S> fieldsToOverrideResolver, FieldIdentifierValueResolver<S> fieldIdentifierValueResolver) {
        this.fieldsToOverrideResolver = fieldsToOverrideResolver;
        this.fieldIdentifierValueResolver = fieldIdentifierValueResolver;
    }

    public void apply(T fieldValue, String overrideId, JSONObject json) {
        Map<String, List<JSONObject>> overrides = this.groupByKey(json, overrideId);
        List<S> subfields = this.fieldsToOverrideResolver.resolve(fieldValue);
        subfields.removeIf(subfield -> this.getOverridesForSubfield(subfield, overrides).stream().anyMatch(this::isRemoveOp));
    }

    protected List<JSONObject> getOverridesForSubfield(S subfield, Map<String, List<JSONObject>> overrides) {
        return overrides.getOrDefault(this.fieldIdentifierValueResolver.resolve(subfield), Collections.emptyList());
    }

    private List<JSONObject> getOverridesJSONById(JSONObject json, String overrideId) {
        Stream<Object> jsonObjectStream = Optional.ofNullable((JSONArray)json.get(overrideId)).orElse(new JSONArray()).stream().map(JSONObject.class::cast);
        return jsonObjectStream.toList();
    }

    protected Map<String, List<JSONObject>> groupByKey(JSONObject json, String overrideId) {
        return this.getOverridesJSONById(json, overrideId).stream().collect(Collectors.groupingBy(p -> p.getOrDefault("id", "")));
    }

    protected boolean isRemoveOp(JSONObject override) {
        return "remove".equals(override.get("op"));
    }
}

