/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AbstractOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.AdminOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.CloseRemoveOrderbookCallBack;
import com.deutscheboerse.comxerv.comtrader.jfx.components.orderbook.ExtendedOrderbookPane;
import com.deutscheboerse.comxerv.comtrader.jfx.service.MagnifiedOrderbookPopupService;
import com.deutscheboerse.comxerv.comtrader.jfx.util.UtilityStages;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.event.PreLogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.deutscheboerse.ui.jfx.util.StageUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

@Singleton
public class MagnifiedOrderbookPopupServiceImpl
implements MagnifiedOrderbookPopupService {
    private static final double HEIGHT = 200.0;
    private static final double WIDTH = 844.0;
    private final ApplicationContext appContext;
    private final Stage stage;
    private double xOffset = 0.0;
    private double yOffset = 0.0;
    private AbstractOrderbookPane orderbookPane;

    @Inject
    public MagnifiedOrderbookPopupServiceImpl(ApplicationContext appContext) {
        this.appContext = appContext;
        this.stage = appContext.getService(UtilityStages.class).withKey(MagnifiedOrderbookPopupService.class.getName()).withStageStyle(StageStyle.UNDECORATED).get();
        this.stage.setTitle(Util.getLabel("magnifiedOrderbookPanel_header_label"));
        appContext.getService(EventBus.class).register(this);
    }

    private void constructPanel(Orderbook orderbook) {
        CloseRemoveOrderbookCallBack closeRemoveOrderbookCallBack = new CloseRemoveOrderbookCallBack(){

            @Override
            public void closeOrderbookPane(AbstractOrderbookPane abstractOrderbookPane) {
                MagnifiedOrderbookPopupServiceImpl.this.stage.hide();
            }

            @Override
            public void removeOrHideOrderbook(Orderbook orderbook) {
                MagnifiedOrderbookPopupServiceImpl.this.stage.hide();
            }
        };
        this.orderbookPane = this.isAbleToSeeAdminPanels() ? new AdminOrderbookPane(this.appContext, orderbook, closeRemoveOrderbookCallBack, new SimpleObjectProperty<Integer>(-1), null) : new ExtendedOrderbookPane(this.appContext, orderbook, closeRemoveOrderbookCallBack, new SimpleObjectProperty<Integer>(-1), null, false);
        this.orderbookPane.setPrefWidth(844.0);
        this.orderbookPane.setPrefHeight(200.0);
        this.orderbookPane.setOnMousePressed(event -> {
            this.xOffset = event.getSceneX();
            this.yOffset = event.getSceneY();
        });
        this.orderbookPane.setOnMouseDragged(event -> {
            this.stage.setX(event.getScreenX() - this.xOffset);
            this.stage.setY(event.getScreenY() - this.yOffset);
        });
        this.orderbookPane.setCollapsible(false);
        BorderPane borderPaneWrapper = new BorderPane();
        borderPaneWrapper.setCenter(this.orderbookPane);
        Scene scene = new Scene(borderPaneWrapper);
        this.stage.setScene(scene);
        this.orderbookPane.requestFocus();
    }

    private boolean isAbleToSeeAdminPanels() {
        return this.appContext.getService(UserService.class).getOwnUser().getRoles().isAbleToSeeFullTrades();
    }

    @Override
    public void showMagnifiedOrderbookPopup(Orderbook orderbook, Node eventSource) {
        if (this.orderbookPane == null) {
            this.constructPanel(orderbook);
        } else {
            this.orderbookPane.orderbookProperty().set(orderbook);
        }
        this.showPopup(eventSource);
    }

    private void showPopup(Node eventSource) {
        Point2D middleScreenCoordinates = this.appContext.getService(StageUtil.class).getMiddleScreenCoordinates(eventSource);
        FxUtil.runLater(() -> {
            if (!this.stage.isShowing()) {
                this.stage.setX(middleScreenCoordinates.getX() - 422.0);
                this.stage.setY(middleScreenCoordinates.getY() - 100.0);
                this.stage.show();
            }
            this.stage.toFront();
        });
    }

    @Override
    public void refreshPanel() {
        if (this.orderbookPane != null) {
            Orderbook orderbook = (Orderbook)this.appContext.getSmallDataModel(Orderbook.class).findById((String)this.orderbookPane.getOrderbook().getId());
            if (orderbook != null) {
                this.constructPanel(orderbook);
            } else {
                this.stage.hide();
            }
        }
    }

    @Subscribe
    public void handlePreLogoutEvent(PreLogoutEvent preLogoutEvent) {
        if (this.appContext.getService(BackendConnectionGateway.class).getSession() == null) {
            this.stage.hide();
        }
    }
}

