/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.csv;

import com.deutscheboerse.comxerv.comtrader.jfx.components.table.GenericCellFactory;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableCellText;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableTableColumn;
import com.deutscheboerse.comxerv.comtrader.jfx.service.csv.ExportableView;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TableView;
import javafx.util.Callback;

public class ExportableTableView<S>
implements ExportableView<S> {
    private final TableView<S> tableView;
    private final Mode mode;

    public ExportableTableView(TableView<S> tableView, Mode mode) {
        this.tableView = tableView;
        this.mode = mode;
    }

    @Override
    public List<String> getColumnNames() {
        return this.tableView.getColumns().stream().filter(this::filterTableColumn).map(TableColumnBase::getText).toList();
    }

    @Override
    public Object getColumnData(int columnIndex, S item) {
        return this.tableView.getColumns().stream().filter(this::filterTableColumn).skip(columnIndex).findFirst().map(column -> this.getCellData(item, (TableColumn<S, ?>)column)).orElse(null);
    }

    private Object getCellData(S item, TableColumn<S, ?> column) {
        GenericCellFactory gcf;
        Object cellData = column.getCellData(item);
        Callback<TableColumn<S, ?>, TableCell<S, ?>> cellFactory = column.getCellFactory();
        if (cellFactory instanceof GenericCellFactory && (gcf = (GenericCellFactory)cellFactory).getCellCustomizer() instanceof ExportableCellText) {
            return ((ExportableCellText)((Object)gcf.getCellCustomizer())).getText(cellData);
        }
        return cellData;
    }

    private boolean filterTableColumn(TableColumn<S, ?> column) {
        return column.isVisible() && (!(column instanceof ExportableTableColumn) || ((ExportableTableColumn)((Object)column)).isExportable());
    }

    @Override
    public List<S> getItems() {
        ObservableList items = this.mode == Mode.SELECTED ? this.tableView.getSelectionModel().getSelectedItems() : this.tableView.getItems();
        return new ArrayList(items);
    }

    public static enum Mode {
        ALL,
        SELECTED;

    }
}

