/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.jfx.service.user;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.session.ConnectionParametersWithFallback;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.ChangePasswordDialog;
import com.deutscheboerse.comxerv.comtrader.jfx.components.mainpanel.TotpConfigDialog;
import com.deutscheboerse.comxerv.comtrader.jfx.service.user.ChangePasswordUiService;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.UserAlertService;
import com.deutscheboerse.comxerv.comtrader.service.user.ChangePasswordService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.Desktop;
import java.net.URI;
import java.util.concurrent.ScheduledExecutorService;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ChangePasswordUiServiceImpl
implements ChangePasswordUiService {
    private static final Logger LOG = LoggerFactory.getLogger(ChangePasswordUiServiceImpl.class);
    private final BackendConnectionGateway backendConnectionGateway;
    private final ApplicationContext applicationContext;
    private final ScheduledExecutorService executorService;
    private final UserAlertService userAlertService;

    @Inject
    public ChangePasswordUiServiceImpl(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.backendConnectionGateway = applicationContext.getService(BackendConnectionGateway.class);
        this.executorService = applicationContext.getService(ScheduledExecutorService.class, WorkerExecutor.class);
        this.userAlertService = applicationContext.getService(UserAlertService.class);
    }

    @Override
    public boolean showChangePasswordButton(Exchange exchange) {
        return this.getChangePasswordService(exchange).changePasswordPossible();
    }

    @Override
    public void showChangePasswordUi(Window ownerWindow) {
        this.showChangePasswordUi(this.backendConnectionGateway.getConnection().getConnectionParameters(), ownerWindow);
    }

    @Override
    public void showChangePasswordUi(ConnectionParametersWithFallback connectionParameters, Window ownerWindow) {
        Exchange exchange = connectionParameters.getExchange();
        if (this.showChangePasswordButton(exchange)) {
            this.showChangePasswordDialog(exchange, ownerWindow);
        } else {
            this.showChangePasswordWeb(connectionParameters);
        }
    }

    private ChangePasswordService getChangePasswordService(Exchange exchange) {
        return this.applicationContext.getService(ChangePasswordService.class, exchange);
    }

    private void showChangePasswordWeb(ConnectionParametersWithFallback connectionParameters) {
        String changePasswordPage = connectionParameters.getChangePasswordHost();
        this.executorService.execute(() -> {
            try {
                Desktop.getDesktop().browse(new URI(changePasswordPage));
            }
            catch (Exception e) {
                LOG.error("", e);
                FxUtil.runInFxThread(() -> this.userAlertService.showConfirmationDialog(Util.getLabel("commons_changePasswordError"), Util.getLabel("commons_changePasswordBrowseError", changePasswordPage, e.getMessage()), UserAlertService.Flag.ERROR));
            }
        });
    }

    private void showChangePasswordDialog(Exchange exchange, Window ownerWindow) {
        this.applicationContext.getService(ChangePasswordDialog.class).show(ownerWindow, exchange);
    }

    @Override
    public void showTotpPasswordUi(Window ownerWindow) {
        this.applicationContext.getService(TotpConfigDialog.class).show(ownerWindow);
    }
}

