/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.module;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.module.ReceiverExecutor;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.module.WorkerExecutor;
import com.deutscheboerse.comxerv.comtrader.monitoring.Monitor;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentService;
import com.deutscheboerse.comxerv.comtrader.service.AssignmentServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractService;
import com.deutscheboerse.comxerv.comtrader.service.BlockContractServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.BlockOrderbookFactory;
import com.deutscheboerse.comxerv.comtrader.service.BlockOrderbookFactoryImpl;
import com.deutscheboerse.comxerv.comtrader.service.BroadcastListenerHandlerForClass;
import com.deutscheboerse.comxerv.comtrader.service.CleanupServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.EulaService;
import com.deutscheboerse.comxerv.comtrader.service.EulaServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.GlobalOrderbookSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.GlobalOrderbookSettingsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.LocalService;
import com.deutscheboerse.comxerv.comtrader.service.LocalServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.LoginService;
import com.deutscheboerse.comxerv.comtrader.service.LoginServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.LogoutService;
import com.deutscheboerse.comxerv.comtrader.service.MemoryService;
import com.deutscheboerse.comxerv.comtrader.service.MemoryServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisherImpl;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.StatusMessageService;
import com.deutscheboerse.comxerv.comtrader.service.StatusMessageServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ActiveExchangeImpl;
import com.deutscheboerse.comxerv.comtrader.service.amqp.BackendConnectionGatewayImpl;
import com.deutscheboerse.comxerv.comtrader.service.amqp.LogoutServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.BespokeServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.ComXervOrderValidator;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.ProductValidator;
import com.deutscheboerse.comxerv.comtrader.service.comxerv.TradeServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.csv.ContinuousTradeExportService;
import com.deutscheboerse.comxerv.comtrader.service.csv.ContinuousTradeExportServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.event.handler.ClearLoggerCacheOnOwnUserLoadedEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.handler.OwnUserLoadedEventHandler;
import com.deutscheboerse.comxerv.comtrader.service.listener.BroadcastListenerHandlerForClassImpl;
import com.deutscheboerse.comxerv.comtrader.service.listener.ContractToOrderbookDataModelListener;
import com.deutscheboerse.comxerv.comtrader.service.listener.CrossBorderIcebergListener;
import com.deutscheboerse.comxerv.comtrader.service.listener.MessageBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.listener.MessagePopupListener;
import com.deutscheboerse.comxerv.comtrader.service.listener.OrderQuoteNotificationBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.listener.TradeSettlementBroadcastListener;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.CommonOrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderQuoteNotificationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderResponseHandlerFactory;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderResponseHandlerFactoryImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.OrderSender;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.action.OrderActionsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.basket.BasketServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency.EmergencyService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.emergency.EmergencyServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.orderquote.OrderQuoteNotificationServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.preference.OrderPreferencesServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.CrossTradeProtectionServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.protection.OrderEntryProtectionServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.CommonOrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidationService;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.OrderValidator;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceLoggingService;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceLoggingServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceStatisticsService;
import com.deutscheboerse.comxerv.comtrader.service.performancemonitoring.PerformanceStatisticsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationService;
import com.deutscheboerse.comxerv.comtrader.service.profile.ProfileMigrationServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsService;
import com.deutscheboerse.comxerv.comtrader.service.statistic.OwnVolumeStatisticsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSettlementProcessor;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeSettlementProcessorImpl;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradingSettingsServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.user.MemberService;
import com.deutscheboerse.comxerv.comtrader.service.user.MemberServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.user.UserService;
import com.deutscheboerse.comxerv.comtrader.service.user.UserServiceImpl;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionServiceImpl;
import com.deutscheboerse.comxerv.comtrader.util.ApplicationPropertiesUtil;
import com.deutscheboerse.comxerv.comtrader.util.ExtendedEventBus;
import com.deutscheboerse.comxerv.comtrader.util.concurrent.ThreadPoolAutoShutdownScheduledExecutorService;
import com.google.common.eventbus.EventBus;
import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class ServiceModule
extends AbstractModule {
    private static final int THREAD_POOL_SIZE_SENDER = 10;
    private static final int THREAD_POOL_SIZE_RECEIVER = 20;
    private static final int THREAD_POOL_SIZE_WORKER = 50;

    @Override
    protected void configure() {
        this.bind(StatusMessageService.class).to(StatusMessageServiceImpl.class).asEagerSingleton();
        this.bind(CrossTradeProtectionService.class).to(CrossTradeProtectionServiceImpl.class);
        this.bind(EmergencyService.class).to(EmergencyServiceImpl.class);
        this.bind(TradeService.class).to(TradeServiceImpl.class);
        this.bind(TradeSettlementProcessor.class).to(TradeSettlementProcessorImpl.class);
        this.bind(BespokeService.class).to(BespokeServiceImpl.class);
        this.bind(ContinuousTradeExportService.class).to(ContinuousTradeExportServiceImpl.class).asEagerSingleton();
        this.bind(OrderEntryProtectionService.class).to(OrderEntryProtectionServiceImpl.class);
        this.bind(OrderPreferencesService.class).to(OrderPreferencesServiceImpl.class);
        this.bind(BasketService.class).to(BasketServiceImpl.class);
        this.bind(TimeService.class).to(TimeServiceImpl.class);
        this.bind(OnBehalfService.class).to(OnBehalfServiceImpl.class).asEagerSingleton();
        this.bind(UserService.class).to(UserServiceImpl.class).asEagerSingleton();
        this.bind(MemberService.class).to(MemberServiceImpl.class);
        this.bind(SettingsService.class).to(SettingsServiceImpl.class);
        this.bind(TradingSettingsService.class).to(TradingSettingsServiceImpl.class);
        this.bind(LocalService.class).to(LocalServiceImpl.class);
        this.bind(BroadcastListenerHandlerForClass.class).to(BroadcastListenerHandlerForClassImpl.class);
        this.bind(BackendConnectionGateway.class).to(BackendConnectionGatewayImpl.class);
        this.bind(ActiveExchange.class).to(ActiveExchangeImpl.class);
        this.bind(LogoutService.class).to(LogoutServiceImpl.class);
        this.bind(OrderSender.class).to(CommonOrderSender.class);
        this.bind(OrderResponseHandlerFactory.class).to(OrderResponseHandlerFactoryImpl.class);
        this.bind(OrderQuoteNotificationService.class).to(OrderQuoteNotificationServiceImpl.class);
        this.bind(GlobalOrderbookSettingsService.class).to(GlobalOrderbookSettingsServiceImpl.class);
        this.bind(CleanupServiceImpl.class).asEagerSingleton();
        this.bind(ApplicationConfigurationService.class).to(ApplicationConfigurationServiceImpl.class).asEagerSingleton();
        this.bind(ExecutorService.class).annotatedWith(WorkerExecutor.class).to(Key.get(ScheduledExecutorService.class, WorkerExecutor.class));
        this.bind(ExecutorService.class).annotatedWith(SenderExecutor.class).to(Key.get(ScheduledExecutorService.class, SenderExecutor.class));
        this.bind(ExecutorService.class).annotatedWith(ReceiverExecutor.class).to(Key.get(ScheduledExecutorService.class, ReceiverExecutor.class));
        this.bind(OrderValidationService.class).to(CommonOrderValidationService.class).in(Scopes.SINGLETON);
        this.bind(OrderValidator.class).to(ComXervOrderValidator.class).in(Scopes.SINGLETON);
        this.bind(ProductValidator.class).asEagerSingleton();
        this.bind(OwnQuantityLookupService.class).to(OwnQuantityLookupServiceImpl.class);
        this.bind(OwnVolumeStatisticsService.class).to(OwnVolumeStatisticsServiceImpl.class);
        this.bind(AssignmentService.class).to(AssignmentServiceImpl.class);
        this.bind(EventBus.class).toInstance(new ExtendedEventBus("Global application event bus"));
        this.bind(BlockOrderbookFactory.class).to(BlockOrderbookFactoryImpl.class);
        this.bind(MessagePopupListener.class).asEagerSingleton();
        this.bind(MessageBroadcastListener.class).asEagerSingleton();
        this.bind(OrderQuoteNotificationBroadcastListener.class).asEagerSingleton();
        this.bind(TradeSettlementBroadcastListener.class).asEagerSingleton();
        this.bind(ContractToOrderbookDataModelListener.class).asEagerSingleton();
        this.bind(CrossBorderIcebergListener.class).asEagerSingleton();
        this.bind(PerformanceStatisticsService.class).to(PerformanceStatisticsServiceImpl.class);
        this.bind(PerformanceLoggingService.class).to(PerformanceLoggingServiceImpl.class);
        this.bind(Monitor.class);
        this.bind(ProfileMigrationService.class).to(ProfileMigrationServiceImpl.class);
        this.bind(OwnUserLoadedEventHandler.class).to(ClearLoggerCacheOnOwnUserLoadedEvent.class).asEagerSingleton();
        this.bind(OrderActionsService.class).to(OrderActionsServiceImpl.class);
        this.bind(BlockContractService.class).to(BlockContractServiceImpl.class);
        this.bind(VersionService.class).to(VersionServiceImpl.class);
        this.bind(MemoryService.class).to(MemoryServiceImpl.class).asEagerSingleton();
        this.bind(EulaService.class).to(EulaServiceImpl.class);
        this.bind(LoginService.class).to(LoginServiceImpl.class);
        this.bind(MessagePublisher.class).to(MessagePublisherImpl.class);
        DB db = Boolean.valueOf(ApplicationPropertiesUtil.getApplicationProperty("useOffHeapLargeDataStorage", Boolean.TRUE.toString())) != false ? DBMaker.tempFileDB().closeOnJvmShutdown().fileDeleteAfterClose().make() : DBMaker.heapDB().closeOnJvmShutdown().make();
        this.bind(DB.class).toInstance(db);
    }

    @Provides
    @Singleton
    @SenderExecutor
    ScheduledExecutorService provideSenderExecutor(EventBus eventBus) {
        return new ThreadPoolAutoShutdownScheduledExecutorService(eventBus, 10, "Comtrader-Sender");
    }

    @Provides
    @Singleton
    @ReceiverExecutor
    ScheduledExecutorService provideReceiverExecutor(EventBus eventBus) {
        return new ThreadPoolAutoShutdownScheduledExecutorService(eventBus, 20, "Comtrader-Receiver");
    }

    @Provides
    @Singleton
    @WorkerExecutor
    ScheduledExecutorService provideWorkerExecutor(EventBus eventBus) {
        return new ThreadPoolAutoShutdownScheduledExecutorService(eventBus, 50, "Comtrader-Worker");
    }
}

