/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.BlockContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.DeliveryArea;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.service.BlockOrderbookFactory;
import com.deutscheboerse.comxerv.comtrader.service.OwnQuantityLookupService;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Optional;

@Singleton
public class BlockOrderbookFactoryImpl
implements BlockOrderbookFactory {
    private final OrderbookQueries orderbookQueries;
    private final OwnQuantityLookupService ownQuantityLookupService;

    @Inject
    public BlockOrderbookFactoryImpl(ApplicationContext applicationContext) {
        this.orderbookQueries = applicationContext.getService(OrderbookQueries.class);
        this.ownQuantityLookupService = applicationContext.getService(OwnQuantityLookupService.class);
    }

    @Override
    public Orderbook createTemporaryBlockOrderbook(BlockContract blockContract, DeliveryArea deliveryArea) {
        Orderbook blockOrderbook = new Orderbook(blockContract, deliveryArea, this.ownQuantityLookupService);
        ArrayList<Orderbook> orderbooks = new ArrayList<Orderbook>();
        for (Contract contract : blockContract.getUnderlyingContracts()) {
            Optional<Orderbook> orderbookOptional = this.orderbookQueries.findByContractAndDeliveryArea(contract, deliveryArea);
            if (!orderbookOptional.isPresent()) continue;
            Orderbook copy = new Orderbook(orderbookOptional.get());
            this.orderbookQueries.findByUnderlyingContractAndDeliveryArea(contract, deliveryArea).forEach(copy::merge);
            orderbooks.add(copy);
        }
        blockOrderbook.updateOrderbooksForVwapCalculation(orderbooks);
        return blockOrderbook;
    }
}

