/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service;

import com.deutscheboerse.comxerv.comtrader.service.LoginException;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SecureConnectionHelper.class);

    private SecureConnectionHelper() {
    }

    public static TrustManager[] getTrustManagers(String customKeystore, String trustPassphrase) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, LoginException {
        X509ExtendedTrustManager customTrustManager = null;
        if (StringUtils.isNotBlank(customKeystore)) {
            try (InputStream customKeystoreStream = SecureConnectionHelper.class.getClassLoader().getResourceAsStream(customKeystore);){
                if (customKeystoreStream != null) {
                    KeyStore tks = KeyStore.getInstance("JKS");
                    tks.load(customKeystoreStream, trustPassphrase.toCharArray());
                    customTrustManager = SecureConnectionHelper.getX509TrustManager(tks);
                }
            }
        }
        return SecureConnectionHelper.getTrustManagers(customTrustManager);
    }

    public static TrustManager[] getTrustManagers(String serverCertFilePath) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException, LoginException {
        X509ExtendedTrustManager customTrustManager = null;
        if (StringUtils.isNotBlank(serverCertFilePath)) {
            try (InputStream serverCertFilePathStream = SecureConnectionHelper.class.getClassLoader().getResourceAsStream(serverCertFilePath);){
                if (serverCertFilePathStream != null) {
                    Certificate certificate = CertificateFactory.getInstance("X.509").generateCertificate(serverCertFilePathStream);
                    KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    keyStore.load(null, null);
                    keyStore.setCertificateEntry("server", certificate);
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init(keyStore);
                    customTrustManager = SecureConnectionHelper.getX509TrustManager(keyStore);
                }
            }
        }
        return SecureConnectionHelper.getTrustManagers(customTrustManager);
    }

    private static TrustManager[] getTrustManagers(X509ExtendedTrustManager customTrustManager) throws KeyStoreException, LoginException {
        X509ExtendedTrustManager trustManager = SecureConnectionHelper.getX509TrustManager(null);
        if (trustManager == null && customTrustManager == null) {
            return new TrustManager[0];
        }
        return new TrustManager[]{new DelegatingX509TrustManager(trustManager, customTrustManager)};
    }

    private static X509ExtendedTrustManager getX509TrustManager(KeyStore keyStore) throws KeyStoreException, LoginException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            Optional<TrustManager> trustManager = Stream.of(trustManagerFactory.getTrustManagers()).filter(X509ExtendedTrustManager.class::isInstance).findAny();
            if (trustManager.isEmpty()) {
                LOG.warn("No X509 trust managers present, returning empty array.");
                return null;
            }
            return (X509ExtendedTrustManager)trustManager.get();
        }
        catch (NoSuchAlgorithmException ex) {
            LOG.error("Cannot instantiate trust manager for the default algorithm (x509) - misconfigured java?");
            throw new LoginException(Util.getLabel("unknown_error", ex));
        }
    }

    public static class DelegatingX509TrustManager
    extends X509ExtendedTrustManager {
        private final List<X509ExtendedTrustManager> trustManagers = new ArrayList<X509ExtendedTrustManager>();

        public DelegatingX509TrustManager(X509ExtendedTrustManager defaultTrustManager, X509ExtendedTrustManager customTrustManager) {
            if (customTrustManager != null) {
                this.trustManagers.add(customTrustManager);
            }
            if (defaultTrustManager != null) {
                this.trustManagers.add(defaultTrustManager);
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkClientTrusted(x509Certificates, authType));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkServerTrusted(x509Certificates, authType));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkClientTrusted(x509Certificates, authType, socket));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkServerTrusted(x509Certificates, authType, socket));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine engine) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkClientTrusted(x509Certificates, authType, engine));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine engine) throws CertificateException {
            this.checkTrusted(x509Certificates, manager -> manager.checkServerTrusted(x509Certificates, authType, engine));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            ArrayList<X509Certificate> acceptedIssuers = new ArrayList<X509Certificate>();
            for (X509TrustManager x509TrustManager : this.trustManagers) {
                acceptedIssuers.addAll(List.of(x509TrustManager.getAcceptedIssuers()));
            }
            return (X509Certificate[])acceptedIssuers.toArray(X509Certificate[]::new);
        }

        private void checkTrusted(X509Certificate[] x509Certificates, CheckTrusted checkTrusted) throws CertificateException {
            if (this.trustManagers.isEmpty()) {
                throw new IllegalStateException("No trust manager present");
            }
            this.validateCertificateChainDates(x509Certificates);
            CertificateException lastException = null;
            for (X509ExtendedTrustManager trustManager : this.trustManagers) {
                try {
                    checkTrusted.invoke(trustManager);
                    return;
                }
                catch (CertificateException e) {
                    lastException = e;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
        }

        private void validateCertificateChainDates(X509Certificate[] x509Certificates) throws CertificateException {
            LOG.info("Check certificate date");
            if (x509Certificates == null || x509Certificates.length == 0) {
                throw new IllegalArgumentException("No certificate found");
            }
            for (X509Certificate certificate : x509Certificates) {
                certificate.checkValidity();
            }
        }
    }

    @FunctionalInterface
    public static interface CheckTrusted {
        public void invoke(X509ExtendedTrustManager var1) throws CertificateException;
    }
}

