/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.amqp;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.entities.session.Session;
import com.deutscheboerse.comxerv.comtrader.service.ApplicationConfigurationService;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpConnectionManager;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpNames;
import com.deutscheboerse.comxerv.comtrader.service.amqp.AmqpUtil;
import com.deutscheboerse.comxerv.comtrader.service.version.VersionService;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Delivery;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.ReturnListener;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.utility.BlockingCell;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpRpcClient.class);
    private static final String APPLICATION_IDENTIFIER_KEY = "APPLICATION_IDENTIFIER";
    private static final String APPLICATION_VERSION_KEY = "app-version";
    private static final int MSG_SEND_RETRY_COUNT = 2;
    private static final RpcDelivery SHUTDOWN_DELIVERY = new RpcDelivery();
    private static final boolean BASIC_PUBLISH_IMMEDIATE = false;
    private static final boolean BASIC_PUBLISH_MANDATORY = true;
    private static final boolean BASIC_CONSUME_AUTO_ACK = true;
    private static final boolean RESPONSE_QUEUE_DURABLE = false;
    private static final boolean RESPONSE_QUEUE_EXCLUSIVE = true;
    private static final boolean RESPONSE_QUEUE_AUTODELETE = true;
    private static final Map<String, Object> RESPONSE_QUEUE_ATTRIBUTES = null;
    private final Map<String, BlockingCell<RpcDelivery>> correlationIdToDeliveryMap = new ConcurrentHashMap<String, BlockingCell<RpcDelivery>>();
    private final AMQP.BasicProperties amqpBasicProperties;
    private final AmqpConnectionManager connectionManager;
    private final List<String> responseQueueNames;
    private final String applicationId;
    private final String applicationVersion;
    private final String requestExchangeName;
    private Channel requestChannel;
    private Channel responseChannel;
    private String responseQueue;

    public AmqpRpcClient(ApplicationContext appContext, Session session, AmqpConnectionManager connectionManager, String contentType) {
        AmqpNames amqpNames = appContext.getService(AmqpNames.class, session.getExchange());
        this.responseQueueNames = amqpNames.getResponseQueueNames(session.getRabbitUser());
        this.requestExchangeName = amqpNames.getRequestExchangeName(session.getRabbitUser());
        this.connectionManager = connectionManager;
        VersionService versionService = appContext.getService(VersionService.class);
        this.applicationId = appContext.getService(ApplicationConfigurationService.class).getBooleanApplicationProperty("withThrottling") ? "DB-TestClient" : appContext.getService(ApplicationConfigurationService.class).getApplicationProperty("application_id");
        this.applicationVersion = versionService.getNormalizedComtraderVersion().toString();
        this.amqpBasicProperties = new AMQP.BasicProperties.Builder().userId(session.getRabbitUser()).contentType(contentType).appId(this.applicationId).build();
    }

    public void initializeConnection() throws IOException, TimeoutException {
        this.initializeChannels();
    }

    public void close() {
        if (this.connectionManager != null) {
            this.connectionManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcDelivery sendMessage(String routingKey, byte[] body, int timeout, boolean retry, String correlationId, boolean compress, AtomicLong eventIndex) throws IOException {
        BlockingCell<RpcDelivery> blockingDelivery = new BlockingCell<RpcDelivery>();
        this.correlationIdToDeliveryMap.put(correlationId, blockingDelivery);
        for (int i = 0; i < 2; ++i) {
            try {
                this.initializeChannels();
                if (this.responseQueue == null) {
                    throw new IllegalStateException("No responseQueue available");
                }
                AMQP.BasicProperties properties = this.amqpBasicProperties.builder().correlationId(correlationId).replyTo(this.responseQueue).headers(this.getAmqpHeaders(eventIndex)).contentEncoding(compress ? "gzip" : null).build();
                LOG.info("Sending properties {}", (Object)properties.getHeaders());
                byte[] bodyToSend = AmqpUtil.compressIfNeeded(properties, body);
                AmqpRpcClient amqpRpcClient = this;
                synchronized (amqpRpcClient) {
                    this.requestChannel.basicPublish(this.requestExchangeName, routingKey, true, false, properties, bodyToSend);
                    break;
                }
            }
            catch (ShutdownSignalException | IOException e) {
                boolean isRecoverable = this.handleException(e, AmqpConnectionManager.ChannelId.REQUEST_CHANNEL_ID);
                if (retry && isRecoverable && i != 1) continue;
                throw e;
            }
            catch (TimeoutException e) {
                this.correlationIdToDeliveryMap.remove(correlationId);
                throw new IOException("Timeout occurred while waiting for response from server");
            }
        }
        return this.getDelivery(timeout, correlationId, blockingDelivery);
    }

    private Map<String, Object> getAmqpHeaders(AtomicLong eventIndex) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put(APPLICATION_IDENTIFIER_KEY, this.applicationId);
        headers.put(APPLICATION_VERSION_KEY, this.applicationVersion);
        if (eventIndex != null) {
            headers.put("event-index", eventIndex.get());
        }
        return headers;
    }

    private RpcDelivery getDelivery(int timeout, String correlationId, BlockingCell<RpcDelivery> blockingDelivery) throws IOException {
        RpcDelivery delivery = null;
        try {
            delivery = blockingDelivery.get(timeout);
        }
        catch (InterruptedException e) {
            LOG.warn("Thread interrupted", e);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException e) {
            LOG.error("Timeout occurred while waiting for response from server", e);
        }
        if (delivery == null) {
            this.correlationIdToDeliveryMap.remove(correlationId);
            throw new IOException("Delivery not present");
        }
        if (delivery instanceof ReturnDelivery) {
            ReturnDelivery returnDelivery = (ReturnDelivery)delivery;
            throw new IOException("Delivery failed " + returnDelivery.getReplyText() + " to exchange: " + returnDelivery.getExchange() + " routingKey: " + returnDelivery.getRoutingKey());
        }
        if (delivery.equals(SHUTDOWN_DELIVERY)) {
            this.correlationIdToDeliveryMap.remove(correlationId);
            throw new IOException("Shutdown occurred while waiting for response from server");
        }
        return delivery;
    }

    private void initializeChannels() throws IOException, TimeoutException {
        if (this.requestChannel != null && this.responseChannel != null) {
            return;
        }
        if (this.requestChannel == null) {
            this.setupRequestChannel();
        }
        if (this.responseChannel == null) {
            this.setupResponseConsumer();
        }
    }

    private boolean handleException(Exception e, AmqpConnectionManager.ChannelId channelId) {
        boolean recoverable = this.connectionManager.handleException(e, channelId);
        if (!recoverable) {
            this.requestChannel = null;
            this.responseChannel = null;
        }
        return recoverable;
    }

    private void setupRequestChannel() throws IOException, TimeoutException {
        LOG.info("Creating new request channel");
        this.requestChannel = this.connectionManager.getChannel(AmqpConnectionManager.ChannelId.REQUEST_CHANNEL_ID, AmqpConnectionManager.ConnectionId.RPC_CONNECTION_ID);
        this.requestChannel.addReturnListener(new RequestReturnListener(this));
        LOG.info("Request channel created");
    }

    private static String queueDeclare(Channel responseChannel, String responseQueueName) throws IOException {
        return responseChannel.queueDeclare(responseQueueName, false, true, true, RESPONSE_QUEUE_ATTRIBUTES).getQueue();
    }

    private void setupResponseConsumer() throws IOException, TimeoutException {
        LOG.info("Creating new response channel");
        String successfullyDeclaredQueueName = this.queueDeclareFromList();
        if (successfullyDeclaredQueueName == null) {
            this.deleteQueuesFromList();
            String successfullyDeclaredQueueNameSecondAttempt = this.queueDeclareFromList();
            if (successfullyDeclaredQueueNameSecondAttempt == null) {
                throw new IllegalStateException("Cannot declare response queue from list " + String.valueOf(this.responseQueueNames));
            }
            this.responseQueue = successfullyDeclaredQueueNameSecondAttempt;
        } else {
            this.responseQueue = successfullyDeclaredQueueName;
        }
        this.responseChannel = this.connectionManager.getChannel(AmqpConnectionManager.ChannelId.RESPONSE_CHANNEL_ID, AmqpConnectionManager.ConnectionId.RPC_CONNECTION_ID);
        DefaultConsumer consumer = new DefaultConsumer(this.responseChannel){

            @Override
            public void handleShutdownSignal(String consumerTag, ShutdownSignalException signal) {
                if (!AmqpRpcClient.this.connectionManager.handleException(signal, AmqpConnectionManager.ChannelId.RESPONSE_CHANNEL_ID)) {
                    for (BlockingCell<RpcDelivery> blockingDelivery : AmqpRpcClient.this.correlationIdToDeliveryMap.values()) {
                        blockingDelivery.set(SHUTDOWN_DELIVERY);
                    }
                }
            }

            @Override
            public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                String replyId = properties.getCorrelationId();
                BlockingCell<RpcDelivery> blockingDelivery = AmqpRpcClient.this.correlationIdToDeliveryMap.remove(replyId);
                RpcDelivery delivery = new RpcDelivery(envelope, properties, body);
                if (blockingDelivery != null) {
                    blockingDelivery.set(delivery);
                }
            }
        };
        this.responseChannel.basicConsume(this.responseQueue, true, consumer);
        LOG.info("Response channel created");
    }

    private void deleteQueuesFromList() {
        for (String responseQueueName : this.responseQueueNames) {
            try {
                Channel channel = this.connectionManager.createChannel(AmqpConnectionManager.ConnectionId.RPC_CONNECTION_ID);
                try {
                    channel.queueDelete(responseQueueName);
                    LOG.debug("queue {} deleted on {}", (Object)responseQueueName, (Object)channel);
                }
                finally {
                    if (channel == null) continue;
                    channel.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Cannot delete queue {}", (Object)responseQueueName, (Object)e);
            }
        }
    }

    private String queueDeclareFromList() {
        for (String responseQueueName : this.responseQueueNames) {
            String string;
            block9: {
                Channel channel = this.connectionManager.createChannel(AmqpConnectionManager.ConnectionId.RPC_CONNECTION_ID);
                try {
                    String queueName = AmqpRpcClient.queueDeclare(channel, responseQueueName);
                    LOG.debug("queue {} declared on {}", (Object)responseQueueName, (Object)channel);
                    string = queueName;
                    if (channel == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (channel != null) {
                            try {
                                channel.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn("Cannot declare queue {}", (Object)responseQueueName, (Object)e);
                    }
                }
                channel.close();
            }
            return string;
        }
        return null;
    }

    public static class RpcDelivery
    extends Delivery {
        private RpcDelivery() {
            super(null, null, null);
        }

        private RpcDelivery(Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
            super(envelope, properties, body == null ? null : Arrays.copyOf(body, body.length));
        }
    }

    private static final class ReturnDelivery
    extends RpcDelivery {
        private final String replyText;
        private final String exchange;
        private final String routingKey;

        private ReturnDelivery(String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) {
            super(null, properties, body);
            this.exchange = exchange;
            this.routingKey = routingKey;
            this.replyText = replyText;
        }

        public String getReplyText() {
            return this.replyText;
        }

        public String getExchange() {
            return this.exchange;
        }

        public String getRoutingKey() {
            return this.routingKey;
        }
    }

    private static final class RequestReturnListener
    implements ReturnListener {
        private final AmqpRpcClient amqpRpcClient;

        private RequestReturnListener(AmqpRpcClient amqpRpcClient) {
            this.amqpRpcClient = amqpRpcClient;
        }

        @Override
        public void handleReturn(int replyCode, String replyText, String exchange, String routingKey, AMQP.BasicProperties properties, byte[] body) {
            LOG.error("Delivery failed: {}, exchange: {}, routingKey: {}", replyText, exchange, routingKey);
            BlockingCell<RpcDelivery> blockingDelivery = this.amqpRpcClient.correlationIdToDeliveryMap.remove(properties.getCorrelationId());
            if (blockingDelivery != null) {
                blockingDelivery.set(new ReturnDelivery(replyText, exchange, routingKey, properties, body));
            }
        }
    }
}

