/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.async;

import com.deutscheboerse.comxerv.comtrader.service.async.AsyncResponse;
import com.deutscheboerse.comxerv.comtrader.service.async.ErrorType;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseStatus;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.deutscheboerse.ui.jfx.util.FxUtil;

@FunctionalInterface
public interface ResponseHandler {
    public static final ResponseHandler EMPTY = asyncResponse -> {};

    public void handleResponse(AsyncResponse var1);

    default public void handleGeneralError() {
        this.handleGeneralError(Util.getLabel("commons_generalError"));
    }

    default public void handleGeneralError(String message) {
        this.handleResponse(new AsyncResponse(ResponseStatus.ERROR, null, message, ErrorType.GENERAL_TECHNICAL_ERROR));
    }

    default public ResponseHandler chain(ResponseHandler another) {
        return asyncResponse -> {
            this.handleResponse(asyncResponse);
            another.handleResponse(asyncResponse);
        };
    }

    default public ResponseHandler runInFxThread() {
        return asyncResponse -> FxUtil.runInFxThread(() -> this.handleResponse(asyncResponse));
    }
}

