/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.comxerv;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.SmallFastDataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.entities.BespokeContract;
import com.deutscheboerse.comxerv.comtrader.entities.Contract;
import com.deutscheboerse.comxerv.comtrader.entities.FullTrade;
import com.deutscheboerse.comxerv.comtrader.module.SenderExecutor;
import com.deutscheboerse.comxerv.comtrader.service.BackendConnectionGateway;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.amqp.CorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ExchangeConnection;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ObjectHandler;
import com.deutscheboerse.comxerv.comtrader.service.amqp.ResponseWithCorrelationId;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandler;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeout;
import com.deutscheboerse.comxerv.comtrader.service.async.ResponseHandlerWithTimeoutFactory;
import com.deutscheboerse.comxerv.comtrader.service.settings.SettingsService;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeService;
import com.deutscheboerse.comxerv.comtrader.service.trade.BespokeSubmitter;
import com.deutscheboerse.comxerv.comtrader.service.trade.TradeProcessingUserInterface;
import com.deutscheboerse.comxerv.comtrader.util.ExchangeSpecificServiceLookup;
import com.deutscheboerse.m7.trading.api.Request;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javafx.beans.value.ObservableObjectValue;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class BespokeServiceImpl
implements BespokeService {
    private static final SettingsService.Settings<Boolean> ENABLE_BESPOKE_TRADE_CONFIRMATION_POPUP_SETTINGS = new SettingsService.Settings<Boolean>("enableBespokeTradeConfirmationPopup", false);
    private static final Logger LOG = LoggerFactory.getLogger(BespokeServiceImpl.class);
    private final BackendConnectionGateway backendConnectionGateway;
    private final ExchangeSpecificServiceLookup serviceLookup;
    private final ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory;
    private final ExecutorService executorService;
    private final SmallFastDataModel<Long, Contract> contractDataModel;
    private final TradeProcessingUserInterface tradeProcessingUserInterface;
    private final SettingsService settingsService;
    private final MessagePublisher messagePublisher;
    private final ObservableObjectValue<Exchange> activeExchange;

    @Inject
    public BespokeServiceImpl(BackendConnectionGateway backendConnectionGateway, ExchangeSpecificServiceLookup serviceLookup, ApplicationContext appContext, ResponseHandlerWithTimeoutFactory responseHandlerWithTimeoutFactory, MessagePublisher messagePublisher) {
        this.backendConnectionGateway = backendConnectionGateway;
        this.serviceLookup = serviceLookup;
        this.responseHandlerWithTimeoutFactory = responseHandlerWithTimeoutFactory;
        this.messagePublisher = messagePublisher;
        this.executorService = appContext.getService(ExecutorService.class, SenderExecutor.class);
        this.contractDataModel = appContext.getSmallDataModel(Contract.class);
        this.tradeProcessingUserInterface = appContext.getService(TradeProcessingUserInterface.class);
        this.settingsService = appContext.getService(SettingsService.class);
        this.activeExchange = appContext.getService(ActiveExchange.class).getActiveExchange();
    }

    @Override
    public void createBespokeContract(BespokeContract bespokeContract, Consumer<BespokeContract> onSuccess) {
        this.sendBespokeContractReq(this.activeExchange.get(), bespokeContract, onSuccess);
    }

    @Override
    public void createBespokeTrade(FullTrade trade, boolean pncTrade, @Nonnull ResponseHandler responseHandler) {
        this.sendBespokeTradeReq(this.activeExchange.get(), trade, pncTrade, responseHandler);
    }

    private void sendRequestWithTimeoutForContract(ResponseHandler responseHandler, BespokeSubmitter submitter, Request request, Consumer<BespokeContract> onSuccess) {
        ExchangeConnection connection = this.backendConnectionGateway.getConnection();
        String correlationId = CorrelationId.next();
        ResponseHandlerWithTimeout responseHandlerWithTimeout = this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId);
        ObjectHandler<Object> objectHandler = this.getObjectHandlerForContract(submitter, correlationId, responseHandlerWithTimeout, onSuccess);
        connection.addObjectHandler(objectHandler);
        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
        ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
        this.processServerResponse(response, responseHandlerWithTimeout, submitter, connection, objectHandler);
    }

    private void sendRequestWithTimeoutForTrade(ResponseHandler responseHandler, BespokeSubmitter submitter, Request request) {
        ExchangeConnection connection = this.backendConnectionGateway.getConnection();
        String correlationId = CorrelationId.next();
        ResponseHandlerWithTimeout responseHandlerWithTimeout = this.responseHandlerWithTimeoutFactory.createHandler(responseHandler, correlationId);
        ObjectHandler<Object> objectHandler = this.getObjectHandlerForTrade(submitter, correlationId, responseHandlerWithTimeout);
        connection.addObjectHandler(objectHandler);
        responseHandlerWithTimeout.startTimeout(() -> connection.removeObjectHandler(objectHandler));
        ResponseWithCorrelationId response = connection.sendRequest(request, false, correlationId);
        this.processServerResponse(response, responseHandlerWithTimeout, submitter, connection, objectHandler);
    }

    private void processServerResponse(ResponseWithCorrelationId responseWithCorrelationId, ResponseHandler responseHandler, BespokeSubmitter submitter, ExchangeConnection connection, ObjectHandler<Object> objectHandler) {
        boolean expectOtherMessages;
        if (responseWithCorrelationId.getResponse() != null && !(expectOtherMessages = submitter.processImmediateServerResponse(responseWithCorrelationId.getResponse(), responseHandler))) {
            connection.removeObjectHandler(objectHandler);
        }
    }

    private ObjectHandler<Object> getObjectHandlerForContract(BespokeSubmitter submitter, String expectedCorrelationId, @Nonnull ResponseHandler responseHandler, Consumer<BespokeContract> onSuccess) {
        return (session, broadcastObject, correlationId) -> {
            if (expectedCorrelationId.equals(correlationId) && submitter.processAsyncServerResponseForContractRequest(broadcastObject, responseHandler, contract -> {
                this.contractDataModel.handleBroadcastEntity(contract);
                onSuccess.accept(contract);
            })) {
                return ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    private ObjectHandler<Object> getObjectHandlerForTrade(BespokeSubmitter submitter, String expectedCorrelationId, ResponseHandler responseHandler) {
        return (session, broadcastObject, correlationId) -> {
            if (expectedCorrelationId.equals(correlationId) && submitter.processAsyncServerResponseForTradeRequest(broadcastObject, responseHandler)) {
                return ObjectHandler.Result.REMOVE;
            }
            return ObjectHandler.Result.RETAIN;
        };
    }

    private void sendBespokeContractReq(Exchange exchange, BespokeContract bespokeContract, Consumer<BespokeContract> onSuccess) {
        this.executorService.submit(() -> {
            ResponseHandler responseHandler = this.messagePublisher::publishMessage;
            try {
                LOG.info("Creating bespoke contract request {}", (Object)bespokeContract);
                BespokeSubmitter submitter = this.serviceLookup.getExchangeSpecificService(BespokeSubmitter.class, exchange);
                if (submitter == null) {
                    LOG.error("No submitter found for exchange " + String.valueOf(exchange));
                    return;
                }
                Request request = submitter.createBespokeContractRequest(bespokeContract);
                this.sendRequestWithTimeoutForContract(responseHandler, submitter, request, onSuccess);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating bespoke contract request {}: {}", (Object)bespokeContract, (Object)e.getMessage());
                responseHandler.handleGeneralError();
            }
        });
    }

    private void sendBespokeTradeReq(Exchange exchange, FullTrade trade, boolean pncTrade, @Nonnull ResponseHandler responseHandler) {
        Runnable submitBespokeTrade = () -> {
            ResponseHandler chainedResponseHandler = responseHandler.chain(this.messagePublisher::publishMessage);
            try {
                LOG.info("Creating bespoke trade request {}", (Object)trade);
                BespokeSubmitter submitter = this.serviceLookup.getExchangeSpecificService(BespokeSubmitter.class, exchange);
                if (submitter == null) {
                    LOG.error("No submitter found for exchange " + String.valueOf(exchange));
                    return;
                }
                Request request = submitter.createBespokeTradeRequest(trade, pncTrade);
                this.sendRequestWithTimeoutForTrade(chainedResponseHandler, submitter, request);
            }
            catch (RuntimeException e) {
                LOG.error("Error while creating bespoke trade request {}: {}", (Object)trade, (Object)e.getMessage());
                chainedResponseHandler.handleGeneralError();
            }
        };
        if (this.isBespokeTradeConfirmationPopupEnabled()) {
            this.tradeProcessingUserInterface.showTradesForProcessing(Collections.singletonList(trade), TradeProcessingUserInterface.Mode.CREATE, tS -> {
                if (tS != null) {
                    this.executorService.submit(submitBespokeTrade);
                }
            });
        } else {
            this.executorService.submit(submitBespokeTrade);
        }
    }

    @Override
    public boolean isBespokeTradeConfirmationPopupEnabled() {
        return this.settingsService.loadSettings(ENABLE_BESPOKE_TRADE_CONFIRMATION_POPUP_SETTINGS);
    }

    @Override
    public void setBespokeTradeConfirmationPopupEnabled(boolean enabled) {
        this.settingsService.storeSettings(ENABLE_BESPOKE_TRADE_CONFIRMATION_POPUP_SETTINGS, enabled);
    }
}

