/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv;

import com.deutscheboerse.comxerv.comtrader.service.csv.ClipboardExportWriter;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ErrorCollector;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.PrepareImportService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ClipboardPrepareImportService
extends PrepareImportService {
    private static final String DOUBLE_QUOTES = "\"";

    @Override
    public List<List<String>> prepareImport(InputStream inputStream, ErrorCollector errorCollector) throws IOException {
        ArrayList<List<String>> outputData = new ArrayList<List<String>>();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try (CSVParser csvParser = new CSVParser(bufferedReader, ClipboardExportWriter.CSVFORMAT);){
            for (CSVRecord csvRecord : csvParser.getRecords()) {
                ArrayList<String> outputRecord = new ArrayList<String>();
                for (String field : csvRecord) {
                    if (field.startsWith("=\"") && field.endsWith(DOUBLE_QUOTES)) {
                        field = field.substring(2, field.length() - 1);
                        field = field.replaceAll("\"\"", DOUBLE_QUOTES);
                    }
                    outputRecord.add(field);
                }
                outputData.add(outputRecord);
            }
        }
        return outputData;
    }
}

