/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.service.csv.MandatoryColumnMap;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.Column;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.MissingResourceException;

public abstract class AbstractColumn<C>
implements Column<C> {
    private final String headerLabel;
    private int columnNr = -1;
    private final Class<C> valueClass;

    protected AbstractColumn(String header, Class<C> valueClass) {
        this.headerLabel = header;
        this.valueClass = valueClass;
    }

    @Override
    public String getHeader() {
        try {
            return Util.getLabel(this.headerLabel);
        }
        catch (MissingResourceException m) {
            return this.headerLabel;
        }
    }

    @Override
    public boolean isMandatory(Exchange exchange) {
        return MandatoryColumnMap.isMandatory(this.getClass());
    }

    @Override
    public Class<C> getValueClass() {
        return this.valueClass;
    }

    public int getColumnNr() {
        return this.columnNr;
    }

    public void setColumnNr(int columnNr) {
        this.columnNr = columnNr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractColumn)) {
            return false;
        }
        AbstractColumn abstractColumn = (AbstractColumn)o;
        if (this.getHeader() != null ? !this.getHeader().equals(abstractColumn.getHeader()) : abstractColumn.getHeader() != null) {
            return false;
        }
        return !(this.valueClass != null ? !this.valueClass.equals(abstractColumn.valueClass) : abstractColumn.valueClass != null);
    }

    public int hashCode() {
        int result = this.getHeader() != null ? this.getHeader().hashCode() : 0;
        result = 31 * result + (this.valueClass != null ? this.valueClass.hashCode() : 0);
        return result;
    }
}

