/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.common;

import com.deutscheboerse.comxerv.comtrader.core.ActiveExchange;
import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.entity.Exchange;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ErrorCollector;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.beans.value.ObservableObjectValue;

public abstract class ImportService<T> {
    private final ApplicationContext appContext;

    protected ImportService(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    protected ApplicationContext getAppContext() {
        return this.appContext;
    }

    public abstract List<ImportColumn<?, T>> getSupportedColumns();

    public abstract T importRecord(List<ImportColumn<?, T>> var1, List<String> var2, int var3, ErrorCollector var4);

    public abstract void validate(T var1, int var2, ErrorCollector var3, Map<String, ImportColumn<?, T>> var4);

    /*
     * WARNING - void declaration
     */
    public List<T> importData(List<List<String>> data, ErrorCollector errorCollector) {
        void var8_15;
        ArrayList<T> result = new ArrayList<T>();
        if (data.size() == 0) {
            errorCollector.addError(Util.getLabel("importException_headerMissing"));
            return null;
        }
        ArrayList columns = new ArrayList();
        List<ImportColumn<?, T>> supportedColumns = this.getSupportedColumns();
        HashMap<String, ImportColumn<?, T>> errorCodeKeysToColumn = Maps.newHashMap();
        for (int i = 0; i < data.get(0).size(); ++i) {
            String string = data.get(0).get(i).trim();
            Object column = null;
            for (ImportColumn<?, T> importColumn : supportedColumns) {
                if (!importColumn.getHeader().equals(string)) continue;
                column = importColumn;
                column.setColumnNr(i + 1);
                break;
            }
            if (column == null) {
                errorCollector.addError(Util.getLabel("importException_unexpectedColumn", string));
                return null;
            }
            columns.add((ImportColumn<?, T>)column);
        }
        for (ImportColumn importColumn : columns) {
            if (importColumn.getErrorCodesKeys() == null) continue;
            for (String string : importColumn.getErrorCodesKeys()) {
                errorCodeKeysToColumn.put(string, importColumn);
            }
        }
        HashSet<Exchange> exchanges = new HashSet<Exchange>();
        int n = 2;
        for (List list : data.subList(1, data.size())) {
            void var8_13;
            Exchange exchange = this.getExchange(columns, list, (int)var8_13, null);
            if (exchange != null) {
                exchanges.add(exchange);
            }
            ++var8_13;
        }
        StringBuilder requiredColumnMissing = new StringBuilder();
        for (ImportColumn<?, T> importColumn : supportedColumns) {
            if (!this.isMandatoryForExchange(exchanges, importColumn) || columns.contains(importColumn)) continue;
            if (requiredColumnMissing.length() > 0) {
                requiredColumnMissing.append(", ");
            }
            requiredColumnMissing.append("\"" + importColumn.getHeader() + "\"");
        }
        if (requiredColumnMissing.length() > 0) {
            String string = requiredColumnMissing.toString();
            errorCollector.addError(Util.getLabel("importException_requiredColumnMissing", string));
            return null;
        }
        boolean bl = true;
        while (var8_15 < data.size()) {
            List<String> list = data.get((int)var8_15);
            if (list.size() != columns.size()) {
                errorCollector.addError(Util.getLabel("importException_columnCountDoesNotMatch"), (int)var8_15);
            } else {
                int n2 = 0;
                for (String field : list) {
                    ImportColumn importColumn = (ImportColumn)columns.get(n2++);
                    Exchange exchange = this.getExchange(columns, list, (int)var8_15, null);
                    if (exchange == null) break;
                    if (!importColumn.isMandatory(exchange) || !field.isEmpty()) continue;
                    errorCollector.addError(Util.getLabel("importException_requiredColumnEmpty", importColumn.getHeader()), (int)var8_15, n2, importColumn.getHeader());
                }
                T importedObject = this.importRecord(columns, list, (int)var8_15, errorCollector);
                this.validate(importedObject, (int)var8_15, errorCollector, errorCodeKeysToColumn);
                result.add(importedObject);
            }
            ++var8_15;
        }
        if (errorCollector.isEmpty()) {
            return result;
        }
        return Collections.emptyList();
    }

    private boolean isMandatoryForExchange(Set<Exchange> exchanges, ImportColumn<?, T> supportedColumn) {
        for (Exchange exchange : exchanges) {
            if (!supportedColumn.isMandatory(exchange)) continue;
            return true;
        }
        return false;
    }

    public Exchange getExchange(List<ImportColumn<?, T>> columns, List<String> record, int lineNr, ErrorCollector errorCollector) {
        ObservableObjectValue<Exchange> activeExchange;
        if (errorCollector != null && columns.size() != record.size()) {
            errorCollector.addError(Util.getLabel("importException_columnCountDoesNotMatch"), lineNr);
        }
        for (int i = 0; i < columns.size(); ++i) {
            ImportColumn<?, T> column = columns.get(i);
            if (!column.getValueClass().equals(Exchange.class)) continue;
            try {
                return (Exchange)column.parseValue(record.get(i));
            }
            catch (ImportException e) {
                if (errorCollector == null) break;
                errorCollector.addError(e.getExplanation(), lineNr, i + 1, column.getHeader());
                break;
            }
        }
        if ((activeExchange = this.appContext.getService(ActiveExchange.class).getActiveExchange()).getValue() != null) {
            return (Exchange)activeExchange.getValue();
        }
        return null;
    }
}

