/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OpenOrClose;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.OpenOrCloseColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderOpenOrCloseColumn
extends OpenOrCloseColumn<Order>
implements ImportColumn<OpenOrClose, Order> {
    public OrderOpenOrCloseColumn(String header) {
        super(header);
    }

    @Override
    public OpenOrClose getValue(Order objectToExport) {
        return objectToExport.getOpenOrClose();
    }

    @Override
    public OpenOrClose parseValue(String data) throws ImportException {
        try {
            return (OpenOrClose)this.parseNamedTypeValue(data);
        }
        catch (ImportException e) {
            throw new ImportException("Invalid position.", Util.getLabel("importException_invalidPosition"));
        }
    }

    @Override
    public void applyValue(OpenOrClose value, Order importedObject) {
        importedObject.setOpenOrClose(value);
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_OPEN_CLOSE_INDICATOR_NOT_SUPPORTED.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_OPEN_CLOSE_INDICATOR_MANDATORY.getMessageKey());
    }
}

