/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.csv.order;

import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportColumn;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.ImportException;
import com.deutscheboerse.comxerv.comtrader.service.csv.common.OrderTypeColumn;
import com.deutscheboerse.comxerv.comtrader.service.orderentry.validation.ValidationMessage;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import java.util.Arrays;
import java.util.Collection;

public class OrderOrderTypeColumn
extends OrderTypeColumn<Order>
implements ImportColumn<OrderType, Order> {
    public OrderOrderTypeColumn(String header) {
        super(header);
    }

    @Override
    public void applyValue(OrderType value, Order importedObject) {
        importedObject.setOrderType(value);
    }

    @Override
    public OrderType parseValue(String data) throws ImportException {
        try {
            return (OrderType)this.parseNamedTypeValue(data);
        }
        catch (ImportException e) {
            throw new ImportException("Invalid type.", Util.getLabel("commons_invalidOrderType"));
        }
    }

    @Override
    public OrderType getValue(Order objectToExport) {
        return objectToExport.getOrderType();
    }

    @Override
    public Collection<String> getErrorCodesKeys() {
        return Arrays.asList(ValidationMessage.ORDER_VALIDATION_ERROR_INVALID_ORDER_TYPE.getMessageKey(), ValidationMessage.ORDER_VALIDATION_ERROR_ICB_NOT_SUPPORTED.getMessageKey());
    }
}

