/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.listener;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.AbstractDataModelListener;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModelListener;
import com.deutscheboerse.comxerv.comtrader.domain.query.OrderbookQueries;
import com.deutscheboerse.comxerv.comtrader.entities.Order;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.Orderbook;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntries;
import com.deutscheboerse.comxerv.comtrader.entities.orderbook.OrderbookEntry;
import com.deutscheboerse.comxerv.comtrader.entities.type.OrderType;
import com.deutscheboerse.comxerv.comtrader.service.time.TimeService;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class CrossBorderIcebergListener
extends AbstractDataModelListener<Order> {
    private final OrderbookQueries orderbookQueries;
    private final TimeService timeService;

    @Inject
    public CrossBorderIcebergListener(ApplicationContext applicationContext) {
        applicationContext.getDataModel(Order.class).registerHencePostOperationListener(this);
        this.orderbookQueries = applicationContext.getService(OrderbookQueries.class);
        this.timeService = applicationContext.getService(TimeService.class);
    }

    @Override
    public DataModelListener.NotificationResult notifyUpdate(Order object) {
        if (object.getOrderType() == OrderType.ICEBERG) {
            this.orderbookQueries.findByContract(object.getContract()).forEach(orderbook -> this.updateEntries((Orderbook)orderbook, object));
        }
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    @Override
    public DataModelListener.NotificationResult notifyRemoveAll() {
        return DataModelListener.NotificationResult.RETAIN_LISTENER;
    }

    private void updateEntries(Orderbook orderbook, Order order) {
        OrderbookEntries orderbookEntries = order.getDirection().isBuy() ? orderbook.getBuys() : orderbook.getSells();
        OrderbookEntry orderbookEntry = orderbookEntries.getEntry((Long)order.getId());
        if (this.isManualRemainingQuantityUpdateNecessary(orderbookEntry, order)) {
            orderbookEntries.batchStarted();
            orderbookEntries.remove(orderbookEntry);
            OrderbookEntry newOrderbookEntry = OrderbookEntry.newBuilder().withOrderId((Long)order.getId()).withPrice(orderbookEntry.getPrice()).withQuantity(orderbookEntry.getQuantity()).withOrderType(orderbookEntry.getOrderType()).withRemainingQuantity(order.getRemainingQuantity()).withOrderId(orderbookEntry.getOrderId()).withExecutionRestriction(orderbookEntry.getExecutionRestriction()).withLocalTimestamp(this.timeService.getLocalTime().getMillis()).withTime(orderbookEntry.getTime()).build();
            orderbookEntries.add(newOrderbookEntry);
            orderbookEntries.batchFinished();
        }
    }

    private boolean isManualRemainingQuantityUpdateNecessary(OrderbookEntry orderbookEntry, Order order) {
        return orderbookEntry != null && orderbookEntry.getPrice().equals(order.getLimitPrice()) && orderbookEntry.getQuantity().equals(order.getShownQuantity()) && !orderbookEntry.getRemainingQuantity().equals(order.getRemainingQuantity());
    }
}

