/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.profile;

import com.deutscheboerse.comxerv.comtrader.util.CleanPath;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileService;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.ProfileServiceException;
import com.deutscheboerse.m7.comtrader.remote.profilestorage.v3.data.Profile;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class LocalProfileService
implements ProfileService {
    private static final Logger LOG = LoggerFactory.getLogger(LocalProfileService.class);
    private final File storageDirectory = new File(CleanPath.cleanString(System.getProperty("user.home")), ".comtrader-profiles");

    public LocalProfileService() {
        if (!this.storageDirectory.exists() && !this.storageDirectory.mkdirs()) {
            String msg = "Could not initialize profile storage directory " + String.valueOf(this.storageDirectory);
            LOG.error(msg);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, msg);
        }
        if (this.storageDirectory.exists() && !this.storageDirectory.isDirectory()) {
            String msg = String.valueOf(this.storageDirectory) + " already exists but it is not a directory.";
            LOG.error(msg);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, msg);
        }
    }

    @Override
    public boolean profileExists(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        File profileFile = this.getProfileFile(exchangeId, userName, environmentId);
        return profileFile.exists() && profileFile.isFile();
    }

    @Override
    public void createProfile(Profile profile) throws ProfileServiceException {
        this.storeProfile(profile);
    }

    @Override
    public Profile loadProfile(String exchangeId, String userName, String environmentId) throws ProfileServiceException {
        Profile profile;
        if (!this.profileExists(exchangeId, userName, environmentId)) {
            throw new ProfileServiceException(ProfileServiceException.ErrorType.PROFILE_DOESNT_EXIST, "Profile doesn't exist.");
        }
        FileReader fileReader = new FileReader(this.getProfileFile(exchangeId, userName, environmentId));
        try {
            JSONObject localProfile = (JSONObject)JSONValue.parseWithException(fileReader);
            profile = this.deserializeProfile(localProfile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, "Could not read profile.", e);
            }
        }
        fileReader.close();
        return profile;
    }

    @Override
    public void storeProfile(Profile profile) throws ProfileServiceException {
        try (FileWriter fileWriter = new FileWriter(this.getProfileFile(profile));){
            JSONObject localProfile = this.serializeProfile(profile);
            localProfile.writeJSONString(fileWriter);
        }
        catch (Exception e) {
            LOG.error("Could not write profile.", e);
            throw new ProfileServiceException(ProfileServiceException.ErrorType.IO_ERROR, "Could not write profile.", e);
        }
    }

    private JSONObject serializeProfile(Profile profile) {
        JSONObject localProfile = new JSONObject();
        localProfile.put("userName", profile.getUserName());
        localProfile.put("exchangeId", profile.getExchangeId());
        localProfile.put("environmentId", profile.getEnvironmentId());
        localProfile.put("formatVersion", profile.getFormatVersion());
        localProfile.put("lastUpdateTimeStamp", profile.getLastProfileSaveTimeStamp());
        localProfile.put("content", profile.getContent());
        return localProfile;
    }

    private Profile deserializeProfile(JSONObject jsonObject) {
        Profile profile = new Profile();
        profile.setUserName((String)jsonObject.get("userName"));
        profile.setExchangeId((String)jsonObject.get("exchangeId"));
        profile.setEnvironmentId((String)jsonObject.get("environmentId"));
        profile.setFormatVersion((Long)jsonObject.get("formatVersion"));
        profile.setLastProfileSaveTimeStamp((Long)jsonObject.get("lastUpdateTimeStamp"));
        profile.setContent((String)jsonObject.get("content"));
        return profile;
    }

    private File getProfileFile(Profile profile) {
        return this.getProfileFile(profile.getExchangeId(), profile.getUserName(), profile.getEnvironmentId());
    }

    private File getProfileFile(String exchangeId, String userName, String environmentId) {
        return new File(this.storageDirectory, exchangeId + "__" + userName + "__" + environmentId + ".json");
    }
}

