/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.remote;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.ProfileLoginFailedEvent;
import com.deutscheboerse.comxerv.comtrader.service.remote.WebServiceFactory;
import com.deutscheboerse.comxerv.comtrader.util.RemoteServiceUtil;
import com.deutscheboerse.m7.comtrader.remote.common.RemoteService;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import org.apache.cxf.transport.http.HTTPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteServiceProxy<S extends RemoteService> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteServiceProxy.class);
    private final WebServiceFactory webServiceFactory;
    private final Class<S> serviceClass;
    private final String serviceName;
    private final RemoteServiceUtil remoteServiceUtil;
    private S remoteService;

    protected RemoteServiceProxy(ApplicationContext applicationContext, Class<S> serviceClass, String serviceName) {
        this.webServiceFactory = applicationContext.getService(WebServiceFactory.class);
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.remoteServiceUtil = applicationContext.getService(RemoteServiceUtil.class);
        applicationContext.getService(EventBus.class).register(this);
    }

    @Subscribe
    public void reset(ProfileLoginFailedEvent loginFailed) {
        this.remoteService = null;
    }

    @Subscribe
    public void reset(LogoutEvent logoutEvent) {
        this.remoteService = null;
    }

    protected S getRemoteService() {
        this.checkApplicationThread();
        if (this.remoteService == null) {
            try {
                this.remoteService = this.getRemoteService(this.remoteServiceUtil.getPrimaryProfileStorageUrl());
                this.remoteService.ping();
            }
            catch (Exception e) {
                LOG.error("Could not create remote service.", e);
                if (this.remoteServiceUtil.getSecondaryProfileStorageUrl() != null) {
                    if (e.getCause() instanceof HTTPException && ((HTTPException)e.getCause()).getResponseCode() == 401) {
                        LOG.error("Could not create remote service, unauthorised access. Trying to connect to backup server skipped.", e);
                        this.remoteService = null;
                        throw e;
                    }
                    LOG.info("Trying backup remote service url.", e);
                    this.remoteService = this.getRemoteService(this.remoteServiceUtil.getSecondaryProfileStorageUrl());
                    this.remoteService.ping();
                }
                throw e;
            }
        }
        return this.remoteService;
    }

    private S getRemoteService(String baseServiceUrl) {
        return this.webServiceFactory.getWebService(this.serviceClass, baseServiceUrl, this.serviceName, this.remoteServiceUtil.getDisableHostnameCheck());
    }

    private void checkApplicationThread() {
        if (Platform.isFxApplicationThread()) {
            LOG.error("RemoteProfileService called from FX thread!", new Exception());
        }
    }
}

