/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.comxerv.comtrader.service.user;

import com.deutscheboerse.comxerv.comtrader.core.ApplicationContext;
import com.deutscheboerse.comxerv.comtrader.core.datamodel.DataModel;
import com.deutscheboerse.comxerv.comtrader.core.entity.BroadcastEntity;
import com.deutscheboerse.comxerv.comtrader.entities.User;
import com.deutscheboerse.comxerv.comtrader.entities.type.MessageSeverity;
import com.deutscheboerse.comxerv.comtrader.service.MessagePublisher;
import com.deutscheboerse.comxerv.comtrader.service.event.LogoutEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.OnBehalfChangeEvent;
import com.deutscheboerse.comxerv.comtrader.service.event.UserDataResetEvent;
import com.deutscheboerse.comxerv.comtrader.service.user.OnBehalfService;
import com.deutscheboerse.comxerv.comtrader.util.Util;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;

@Singleton
public class OnBehalfServiceImpl
implements OnBehalfService {
    private final ObjectProperty<User> selectedUser = new SimpleObjectProperty<User>();
    private final Set<OnBehalfService.OnBehalfChangeVeto> onBehalfChangeVetos = new HashSet<OnBehalfService.OnBehalfChangeVeto>();
    private final EventBus eventBus;
    private final DataModel<Integer, User> userDataModel;
    private final MessagePublisher messagePublisher;

    @Inject
    public OnBehalfServiceImpl(ApplicationContext applicationContext) {
        this.eventBus = applicationContext.getService(EventBus.class);
        this.userDataModel = applicationContext.getDataModel(User.class);
        this.messagePublisher = applicationContext.getService(MessagePublisher.class);
        this.eventBus.register(this);
    }

    @Subscribe
    public void handleLogout(LogoutEvent logoutEvent) {
        this.selectedUser.set(null);
    }

    @Subscribe
    public void handleUserDataReset(UserDataResetEvent event) {
        if (this.selectedUser.get() != null) {
            this.selectedUser.set(null);
            this.messagePublisher.publishMessage(Util.getLabel("onBehalfResetBecauseOfUserDataReset"), MessageSeverity.HIGH);
        }
    }

    @Override
    public void reloadOnBehalfUser() {
        User currentUser = (User)this.selectedUser.get();
        this.selectedUser.set(null);
        Optional.ofNullable(currentUser).map(BroadcastEntity::getId).map(this.userDataModel::findById).ifPresent(this.selectedUser::set);
    }

    @Override
    public boolean setOnBehalfUser(User user) {
        User currentOnBehalfUser = (User)this.selectedUser.get();
        if (currentOnBehalfUser != null && this.onBehalfChangeVetos.stream().anyMatch(veto -> veto.vetoOnBehalfChange(currentOnBehalfUser))) {
            return false;
        }
        if (currentOnBehalfUser == null && this.onBehalfChangeVetos.stream().anyMatch(OnBehalfService.OnBehalfChangeVeto::vetoOnBehalfEnter)) {
            return false;
        }
        this.eventBus.post(new OnBehalfChangeEvent());
        this.selectedUser.set(user);
        return true;
    }

    @Override
    public ReadOnlyObjectProperty<User> onBehalfUserProperty() {
        return this.selectedUser;
    }

    @Override
    public Integer getOnBehalfUserId() {
        User onBehalfUser = (User)this.selectedUser.get();
        return onBehalfUser == null ? null : (Integer)onBehalfUser.getId();
    }

    @Override
    public User getOnBehalfUser() {
        return (User)this.selectedUser.get();
    }

    @Override
    public void registerOnBehalfVeto(OnBehalfService.OnBehalfChangeVeto onBehalfChangeVeto) {
        this.onBehalfChangeVetos.add(onBehalfChangeVeto);
    }
}

