/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.m7.trading.api;

import com.deutscheboerse.m7.trading.api.ErrorCodeAndKey;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.function.BiConsumer;

public class MessageResources {
    private static final String DEFAULT_NAME = "MessageResources";
    private Properties bundle;

    public MessageResources() throws IOException {
        this.loadDefaultBundle();
    }

    public void updateProperties(Properties bundle) {
        bundle.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.bundle.replace(key, value)));
    }

    private void loadDefaultBundle() throws IOException {
        String suffix = ".properties";
        String file = DEFAULT_NAME.replace('.', '/');
        String defaultFileName = file + suffix;
        this.bundle = new Properties();
        try (InputStream inputStream = MessageResources.class.getClassLoader().getResourceAsStream(defaultFileName);){
            this.bundle.load(inputStream);
        }
    }

    public String format(ErrorCodeAndKey errorCodeAndKey, Object ... args2) {
        return this.format(errorCodeAndKey.getText(), args2);
    }

    public String format(String key, Object ... args2) {
        String pattern = (String)this.bundle.get(key);
        if (pattern != null) {
            return MessageFormat.format(pattern, args2);
        }
        return key;
    }
}

