/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final Exception originalContext;
    private static final Logger LOG = LoggerFactory.getLogger(LoggingCallable.class);

    public LoggingCallable(Callable<V> delegate) {
        this.delegate = delegate;
        this.originalContext = new Exception();
    }

    @Override
    public V call() throws Exception {
        try {
            return this.delegate.call();
        }
        catch (Exception e) {
            this.originalContext.initCause(e);
            LOG.error("Error during execution of " + this.delegate.toString(), this.originalContext);
            throw e;
        }
    }

    public String toString() {
        return this.delegate.toString();
    }
}

