/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util;

import java.util.Optional;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class StageUtil {
    public void moveStageToVisibleArea(Stage stage) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (Screen screen : Screen.getScreens()) {
            maxX = Math.max(maxX, screen.getBounds().getMaxX());
            maxY = Math.max(maxY, screen.getBounds().getMaxY());
            minX = Math.min(minX, screen.getBounds().getMinX());
            minY = Math.min(minY, screen.getBounds().getMinY());
        }
        maxX -= stage.getWidth();
        maxY -= stage.getHeight();
        if (stage.getX() > maxX) {
            stage.setX(maxX);
        }
        if (stage.getY() > maxY) {
            stage.setY(maxY);
        }
        if (stage.getY() < minY) {
            stage.setY(minY);
        }
        if (stage.getX() < minX) {
            stage.setX(minX);
        }
    }

    public Point2D getMiddleScreenCoordinates(Node node) {
        Optional<Bounds> screenBounds = Optional.ofNullable(node).map(Node::getLayoutBounds).map(node::localToScreen);
        Screen screen = screenBounds.flatMap(this::getScreen).orElse(Screen.getPrimary());
        return this.getMiddleScreenCoordinates(screen);
    }

    private Optional<Screen> getScreen(Bounds screenBounds) {
        return Screen.getScreensForRectangle(screenBounds.getMinX(), screenBounds.getMinY(), screenBounds.getWidth(), screenBounds.getHeight()).stream().findFirst();
    }

    public Point2D getMiddleScreenCoordinates(Screen screen) {
        Rectangle2D bounds = screen.getVisualBounds();
        double middleX = bounds.getMinX() + bounds.getWidth() / 2.0;
        double middleY = bounds.getMinY() + bounds.getHeight() / 2.0;
        return new Point2D(middleX, middleY);
    }
}

