/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.binding;

import java.util.List;
import java.util.function.Function;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public class MappedObservableList<E, S>
extends TransformationList<E, S> {
    private final Function<S, E> mapper;

    protected MappedObservableList(ObservableList<? extends S> source, Function<S, E> mapper) {
        super(source);
        this.mapper = mapper;
    }

    public static <E, S> ObservableList<E> get(ObservableList<? extends S> source, Function<S, E> mapped) {
        return FXCollections.unmodifiableObservableList(new MappedObservableList<E, S>(source, mapped));
    }

    @Override
    protected void sourceChanged(final ListChangeListener.Change<? extends S> sourceChange) {
        this.fireChange(new ListChangeListener.Change<E>(this){

            @Override
            public boolean next() {
                return sourceChange.next();
            }

            @Override
            public void reset() {
                sourceChange.reset();
            }

            @Override
            public int getFrom() {
                return sourceChange.getFrom();
            }

            @Override
            public int getTo() {
                return sourceChange.getTo();
            }

            @Override
            public List<E> getRemoved() {
                return sourceChange.getRemoved().stream().map(MappedObservableList.this.mapper).toList();
            }

            @Override
            protected int[] getPermutation() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean wasPermutated() {
                return sourceChange.wasPermutated();
            }

            @Override
            public int getPermutation(int i) {
                return sourceChange.getPermutation(i);
            }

            @Override
            public boolean wasAdded() {
                return sourceChange.wasAdded();
            }

            @Override
            public boolean wasRemoved() {
                return sourceChange.wasRemoved();
            }

            @Override
            public boolean wasReplaced() {
                return sourceChange.wasReplaced();
            }

            @Override
            public boolean wasUpdated() {
                return sourceChange.wasUpdated();
            }

            @Override
            public int getRemovedSize() {
                return sourceChange.getRemovedSize();
            }

            @Override
            public List<E> getAddedSubList() {
                return sourceChange.getAddedSubList().stream().map(MappedObservableList.this.mapper).toList();
            }

            @Override
            public int getAddedSize() {
                return sourceChange.getAddedSize();
            }
        });
    }

    @Override
    public int getSourceIndex(int index) {
        return index;
    }

    @Override
    public E get(int index) {
        return this.mapper.apply(this.getSource().get(index));
    }

    @Override
    public int size() {
        return this.getSource().size();
    }

    @Override
    public int getViewIndex(int index) {
        return index;
    }
}

