/*
 * Decompiled with CFR 0.152.
 */
package com.deutscheboerse.ui.jfx.util.control;

import java.util.function.Supplier;
import javafx.geometry.Orientation;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;

public class ScrollLessListView<S>
extends ListView<S> {
    public static final double DEFAULT_MAX_HEIGHT = 240.0;

    public ScrollLessListView() {
        this.setMaxHeight(240.0);
    }

    @Override
    protected Skin<?> createDefaultSkin() {
        return new ScrollLessListViewSkin(this);
    }

    private static class ScrollLessListViewSkin<S>
    extends ListViewSkin<S> {
        public ScrollLessListViewSkin(ListView<S> listView) {
            super(listView);
        }

        @Override
        protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
            return Math.ceil(leftInset + ((ScrollLessVirtualFlow)this.getVirtualFlow()).computePrefWidth(height) + rightInset);
        }

        @Override
        protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
            return Math.ceil(topInset + ((ScrollLessVirtualFlow)this.getVirtualFlow()).computePrefHeight(width) + bottomInset);
        }

        @Override
        protected VirtualFlow<ListCell<S>> createVirtualFlow() {
            return new ScrollLessVirtualFlow<ListCell<S>>(this::getMaxLenght);
        }

        private double getMaxLenght() {
            return ((ListView)this.getSkinnable()).getOrientation() == Orientation.VERTICAL ? ((ListView)this.getSkinnable()).getMaxHeight() : ((ListView)this.getSkinnable()).getMaxWidth();
        }
    }

    private static class ScrollLessVirtualFlow<T extends IndexedCell>
    extends VirtualFlow<T> {
        private final Supplier<Double> maxLenght;

        public ScrollLessVirtualFlow(Supplier<Double> maxLenght) {
            this.maxLenght = maxLenght;
        }

        @Override
        protected void layoutChildren() {
            super.layoutChildren();
            this.hideScrollBars();
        }

        private void hideScrollBars() {
            if (this.isVertical() || this.maxLenght.get() <= 0.0) {
                this.getChildren().remove(this.getHbar());
            }
            if (!this.isVertical() || this.maxLenght.get() <= 0.0) {
                this.getChildren().remove(this.getVbar());
            }
        }

        @Override
        protected double computePrefWidth(double height) {
            if (!this.isVertical() && this.maxLenght.get() > 0.0) {
                return Math.min(super.computePrefWidth(height), this.maxLenght.get());
            }
            return super.computePrefWidth(height);
        }

        @Override
        protected double computePrefHeight(double width) {
            if (this.isVertical() && this.maxLenght.get() > 0.0) {
                return Math.min(super.computePrefHeight(width), this.maxLenght.get());
            }
            return super.computePrefHeight(width);
        }
    }
}

