/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableByteStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableByteStack;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.ByteArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableByteStackFactory.class)
public class MutableByteStackFactoryImpl
implements MutableByteStackFactory {
    public static final MutableByteStackFactory INSTANCE = new MutableByteStackFactoryImpl();

    @Override
    public MutableByteStack empty() {
        return new ByteArrayStack();
    }

    @Override
    public MutableByteStack of() {
        return this.empty();
    }

    @Override
    public MutableByteStack with() {
        return this.empty();
    }

    @Override
    public MutableByteStack of(byte ... items) {
        return this.with(items);
    }

    @Override
    public MutableByteStack with(byte ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return ByteArrayStack.newStackWith(items);
    }

    @Override
    public MutableByteStack ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableByteStack withAll(ByteIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ByteArrayStack.newStack(items);
    }

    @Override
    public MutableByteStack ofAll(Iterable<Byte> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableByteStack withAll(Iterable<Byte> iterable) {
        MutableByteStack stack = ByteStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableByteStack ofAllReversed(ByteIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableByteStack withAllReversed(ByteIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ByteArrayStack.newStackFromTopToBottom(items);
    }
}

