/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx;

import java.util.function.Consumer;
import org.reactfx.EventStream;
import org.reactfx.EventStreamBase;
import org.reactfx.Subscription;

class DefaultEventStream<T>
extends EventStreamBase<T> {
    private final EventStream<T> input;
    private final T initial;
    private T latestEvent = null;
    private boolean firstObserver = true;
    private boolean emitted = false;

    public DefaultEventStream(EventStream<T> input, T initial) {
        this.input = input;
        this.initial = initial;
    }

    @Override
    protected void newObserver(Consumer<? super T> observer) {
        if (this.firstObserver) {
            this.firstObserver = false;
            if (!this.emitted) {
                observer.accept(this.initial);
            }
        } else {
            observer.accept(this.latestEvent);
        }
    }

    @Override
    protected final Subscription observeInputs() {
        this.firstObserver = true;
        this.emitted = false;
        this.latestEvent = this.initial;
        return this.input.subscribe(x -> {
            this.latestEvent = x;
            this.emitted = true;
            this.emit(x);
        });
    }
}

