/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.HashMap;
import java.util.Iterator;
import org.reactfx.util.AccuMap;
import org.reactfx.util.AccumulationFacility;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

class HashAccuMap<K, V, A>
extends HashMap<K, A>
implements AccuMap<K, V, A> {
    HashAccuMap() {
    }

    @Override
    public Tuple2<K, A> peek(AccumulationFacility<V, A> af) {
        K key = this.pickKey();
        Object acc = this.get(key);
        return Tuples.t(key, acc);
    }

    @Override
    public AccuMap<K, V, A> dropPeeked() {
        K key = this.pickKey();
        this.remove(key);
        return this;
    }

    @Override
    public AccuMap<K, V, A> updatePeeked(A newAccumulatedValue) {
        K key = this.pickKey();
        this.put(key, newAccumulatedValue);
        return this;
    }

    @Override
    public AccuMap<K, V, A> addAll(Iterator<K> keys2, V value, AccumulationFacility<V, A> af) {
        while (keys2.hasNext()) {
            Object accum;
            K key = keys2.next();
            if (this.containsKey(key)) {
                accum = this.get(key);
                accum = af.reduce(accum, value);
                this.put(key, accum);
                continue;
            }
            accum = af.initialAccumulator(value);
            this.put(key, accum);
        }
        return this;
    }

    private K pickKey() {
        return this.keySet().iterator().next();
    }
}

